/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import java.util.Iterator;
import mikera.arrayz.INDArray;
import mikera.indexz.GrowableIndex;
import mikera.indexz.Index;
import mikera.vectorz.AVector;
import mikera.vectorz.GrowableVector;
import mikera.vectorz.Tools;
import mikera.vectorz.impl.ISparseVector;
import mikera.vectorz.impl.IndexedElementVisitor;
import mikera.vectorz.impl.SparseIndexedVector;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public class GrowableIndexedVector
extends AVector
implements ISparseVector {
    private static final long serialVersionUID = 441979517032171392L;
    private int length;
    private final GrowableIndex index;
    private final GrowableVector data;

    private GrowableIndexedVector(int length, GrowableIndex index, GrowableVector data) {
        this.length = length;
        this.index = index;
        this.data = data;
    }

    private GrowableIndexedVector(int length) {
        this.length = length;
        this.index = new GrowableIndex();
        this.data = new GrowableVector();
    }

    private GrowableIndexedVector() {
        this(0);
    }

    public static GrowableIndexedVector create(Iterable<?> iterable) {
        GrowableIndexedVector v = new GrowableIndexedVector();
        for (Object o : iterable) {
            ++v.length;
            double d = Tools.toDouble(o);
            if (d == 0.0) continue;
            v.append(v.length - 1, d);
        }
        return v;
    }

    public static GrowableIndexedVector create(AVector v) {
        if (v instanceof ISparseVector) {
            return GrowableIndexedVector.create((ISparseVector)((Object)v));
        }
        return new GrowableIndexedVector(v.length(), GrowableIndex.wrap((int[])v.nonZeroIndices().clone()), GrowableVector.wrap((double[])v.nonZeroValues().clone()));
    }

    public static GrowableIndexedVector create(ISparseVector v) {
        return new GrowableIndexedVector(v.length(), GrowableIndex.create(v.nonSparseIndex()), GrowableVector.create(v.nonSparseValues()));
    }

    public static GrowableIndexedVector create(Iterator<?> iterator) {
        GrowableIndexedVector v = new GrowableIndexedVector();
        while (iterator.hasNext()) {
            ++v.length;
            double d = Tools.toDouble(iterator.next());
            if (d == 0.0) continue;
            v.append(v.length - 1, d);
        }
        return v;
    }

    public static GrowableIndexedVector createLength(int len) {
        return new GrowableIndexedVector(len);
    }

    @Override
    public double get(int i) {
        this.checkIndex(i);
        int ix = this.index.indexPosition(i);
        if (ix < 0) {
            return 0.0;
        }
        return this.data.get(ix);
    }

    public void append(int i, double value) {
        this.index.checkedAppend(i);
        this.data.append(value);
        if (i >= this.length) {
            this.length = i + 1;
        }
    }

    @Override
    public void set(int i, double value) {
        if (i < 0) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex((INDArray)this, (long)i));
        }
        if (i >= this.length) {
            this.append(i, value);
            return;
        }
        int ix = this.index.indexPosition(i);
        if (ix < 0) {
            int pos = this.index.include(i);
            if (this.index.length() > this.data.length()) {
                this.data.insert(pos, value);
            } else {
                this.data.set(pos, value);
            }
        } else {
            this.data.unsafeSet(ix, value);
        }
    }

    public void append(double v) {
        this.set(this.length, v);
    }

    @Override
    public boolean isFullyMutable() {
        return true;
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        return this.toSparseIndexedVector().dotProduct(data, offset);
    }

    @Override
    public SparseIndexedVector toSparseIndexedVector() {
        return SparseIndexedVector.wrap(this.length, Index.create(this.index), this.data.toDoubleArray());
    }

    @Override
    public AVector exactClone() {
        return new GrowableIndexedVector(this.length, this.index.exactClone(), this.data.exactClone());
    }

    @Override
    public SparseIndexedVector sparseClone() {
        return this.toSparseIndexedVector();
    }

    @Override
    public SparseIndexedVector sparse() {
        return this.toSparseIndexedVector();
    }

    public int nonSparseElementCount() {
        return this.index.length();
    }

    @Override
    public AVector nonSparseValues() {
        return this.data;
    }

    @Override
    public Index nonSparseIndex() {
        return Index.create(this.index);
    }

    public boolean includesIndex(int i) {
        return this.index.indexPosition(i) >= 0;
    }

    @Override
    public void validate() {
        int dl;
        int il = this.index.length();
        if (il != (dl = this.data.length())) {
            throw new VectorzException("Mismatched index and data length!");
        }
        if (il > this.length) {
            throw new VectorzException("Index larger than length!");
        }
        if (dl > this.length) {
            throw new VectorzException("Data larger than length!");
        }
        if (this.index.get(il - 1) >= this.length) {
            throw new VectorzException("Last element beyond length!");
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    public void setLength(int length) {
        if (length > this.length || this.index.last() < length) {
            this.length = length;
            return;
        }
    }

    @Override
    public boolean equalsArray(double[] data, int offset) {
        return this.toSparseIndexedVector().equalsArray(data, offset);
    }

    @Override
    public double visitNonZero(IndexedElementVisitor elementVisitor) {
        return this.toSparseIndexedVector().visitNonZero(elementVisitor);
    }
}

