/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.impl;

import mikera.vectorz.AVector;
import mikera.vectorz.impl.AStridedVector;
import mikera.vectorz.util.DoubleArrays;

public abstract class BaseStridedVector
extends AStridedVector {
    private static final long serialVersionUID = 7038506080494281379L;
    protected final int stride;
    protected final int offset;

    protected BaseStridedVector(int length, double[] data, int offset, int stride) {
        super(length, data);
        int lastOffset;
        this.stride = stride;
        this.offset = offset;
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length > 0 && ((lastOffset = offset + (length - 1) * stride) >= data.length || lastOffset < 0)) {
            throw new IndexOutOfBoundsException("StridedVector ends outside array");
        }
    }

    @Override
    public final int getArrayOffset() {
        return this.offset;
    }

    @Override
    public final int getStride() {
        return this.stride;
    }

    @Override
    protected final int index(int i) {
        return this.offset + i * this.stride;
    }

    @Override
    public final double get(int i) {
        this.checkIndex(i);
        return this.data[this.offset + i * this.stride];
    }

    @Override
    public final double unsafeGet(int i) {
        return this.data[this.offset + i * this.stride];
    }

    @Override
    public double dotProduct(double[] ds, int off) {
        return DoubleArrays.dotProduct(ds, off, this.data, this.offset, this.stride, this.length);
    }

    @Override
    public double dotProduct(double[] ds, int doffset, int dstride) {
        return DoubleArrays.dotProduct(this.data, this.offset, this.stride, ds, doffset, dstride, this.length);
    }

    @Override
    public double dotProduct(AVector v) {
        this.checkLength(v.length());
        return v.dotProduct(this.getArray(), this.getArrayOffset(), this.getStride());
    }
}

