/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz;

import java.util.Iterator;
import mikera.arrayz.INDArray;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.Vectorz;
import mikera.vectorz.impl.IndexedElementVisitor;
import mikera.vectorz.util.DoubleArrays;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class GrowableVector
extends AVector {
    private static final long serialVersionUID = -4560854157937758671L;
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private double[] data;
    private int count;

    public GrowableVector(AVector v) {
        this(v.length());
        this.append(v);
    }

    public GrowableVector(int initialCapacity) {
        this(DoubleArrays.create(initialCapacity), 0);
    }

    public GrowableVector() {
        this(4);
    }

    public static GrowableVector ofInitialCapacity(int capacity) {
        return new GrowableVector(capacity);
    }

    private GrowableVector(double[] array, int length) {
        this.data = array;
        this.count = length;
    }

    public static GrowableVector create(Iterable<Number> iterable) {
        GrowableVector v = new GrowableVector();
        for (Number n : iterable) {
            v.append(n.doubleValue());
        }
        return v;
    }

    public static GrowableVector create(AVector values) {
        return GrowableVector.wrap(values.toDoubleArray());
    }

    public static GrowableVector wrap(double[] values) {
        return new GrowableVector(values, values.length);
    }

    public static GrowableVector create(Iterator<Number> iterator) {
        GrowableVector v = new GrowableVector();
        while (iterator.hasNext()) {
            v.append(iterator.next().doubleValue());
        }
        return v;
    }

    @Override
    public int length() {
        return this.count;
    }

    public int currentCapacity() {
        return this.data.length;
    }

    public void ensureCapacity(int capacity) {
        int cc = this.currentCapacity();
        if (capacity <= cc) {
            return;
        }
        double[] newData = new double[Math.max(capacity + 5, cc * 2)];
        System.arraycopy(this.data, 0, newData, 0, this.count);
        this.data = newData;
    }

    @Override
    public double get(int i) {
        this.checkIndex(i);
        return this.data[i];
    }

    @Override
    public void set(int i, double value) {
        if (i < 0) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidIndex((INDArray)this, (long)i));
        }
        int newMinLength = i + 1;
        if (this.count < newMinLength) {
            this.ensureCapacity(newMinLength);
            this.count = newMinLength;
        }
        this.data[i] = value;
    }

    @Override
    public double unsafeGet(int i) {
        return this.data[i];
    }

    @Override
    public void unsafeSet(int i, double value) {
        this.data[i] = value;
    }

    @Override
    public boolean isView() {
        return false;
    }

    public void append(double v) {
        this.ensureCapacity(this.count + 1);
        this.data[this.count++] = v;
    }

    public void append(double ... vs) {
        int n = vs.length;
        this.ensureCapacity(this.count + n);
        System.arraycopy(vs, 0, this.data, this.count, n);
        this.count += n;
    }

    public void append(AVector v) {
        int vl = v.length();
        this.ensureCapacity(this.count + vl);
        v.getElements(this.data, this.count);
        this.count += vl;
    }

    public AVector build() {
        return Vectorz.create(this);
    }

    @Override
    public GrowableVector clone() {
        return new GrowableVector((double[])this.data.clone(), this.count);
    }

    public void clear() {
        this.count = 0;
    }

    @Override
    public GrowableVector exactClone() {
        GrowableVector g = new GrowableVector(this.data.length);
        g.append(this);
        return g;
    }

    @Override
    public void validate() {
        if (this.count > this.data.length) {
            throw new VectorzException("data array is wrong size!?!");
        }
        super.validate();
    }

    @Override
    public Vector toVector() {
        return Vector.create(this);
    }

    @Override
    public double[] toDoubleArray() {
        double[] result = new double[this.count];
        this.getElements(result, 0);
        return result;
    }

    @Override
    public void getElements(double[] dest, int offset) {
        System.arraycopy(this.data, 0, dest, offset, this.count);
    }

    @Override
    public double dotProduct(double[] data, int offset) {
        return DoubleArrays.dotProduct(data, offset, this.data, 0, this.count);
    }

    @Override
    public boolean equalsArray(double[] data, int offset) {
        return DoubleArrays.equals(this.data, 0, data, offset, this.count);
    }

    public void insert(int pos, double value) {
        if (pos > this.count) {
            throw new IllegalArgumentException("Attempting to insert beyond bounds of GrowableVector, length=" + this.count + " and position=" + pos);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.data, pos, this.data, pos + 1, this.count - pos);
        this.data[pos] = value;
        ++this.count;
    }

    public static Object create(double[] nonZeroValues) {
        return null;
    }

    @Override
    public double visitNonZero(IndexedElementVisitor elementVisitor) {
        return this.toVector().visitNonZero(elementVisitor);
    }
}

