/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import java.util.Arrays;
import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.ARectangularMatrix;
import mikera.matrixx.impl.IFastColumns;
import mikera.matrixx.impl.IFastRows;
import mikera.vectorz.AVector;
import mikera.vectorz.impl.RepeatedElementVector;
import mikera.vectorz.util.ErrorMessages;

public final class BroadcastVectorMatrix
extends ARectangularMatrix
implements IFastRows,
IFastColumns {
    private static final long serialVersionUID = 8586152718389477791L;
    private final AVector source;

    private BroadcastVectorMatrix(AVector v, int rows) {
        super(rows, v.length());
        this.source = v;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public static BroadcastVectorMatrix wrap(AVector v, int rows) {
        return new BroadcastVectorMatrix(v, rows);
    }

    @Override
    public AVector getRowView(int row) {
        this.checkRow(row);
        return this.source;
    }

    @Override
    public AVector getRow(int row) {
        this.checkRow(row);
        return this.source;
    }

    @Override
    public AVector getColumn(int col) {
        return RepeatedElementVector.create(this.rows, this.source.get(col));
    }

    @Override
    public final void copyColumnTo(int col, double[] dest, int destOffset) {
        double v = this.source.get(col);
        Arrays.fill(dest, destOffset, destOffset + this.rows, v);
    }

    @Override
    public final void copyRowTo(int row, double[] dest, int destOffset) {
        this.source.getElements(dest, destOffset);
    }

    @Override
    public AMatrix subMatrix(int rowStart, int rows, int colStart, int cols) {
        return BroadcastVectorMatrix.wrap(this.source.subVector(colStart, cols), rows);
    }

    @Override
    public AMatrix exactClone() {
        return BroadcastVectorMatrix.wrap(this.source.exactClone(), this.rows);
    }

    @Override
    public double get(int row, int column) {
        this.checkRow(row);
        return this.source.get(column);
    }

    @Override
    public double unsafeGet(int row, int column) {
        return this.source.unsafeGet(column);
    }

    @Override
    public void set(int row, int column, double value) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public boolean isZero() {
        return this.source.isZero();
    }

    @Override
    public void setSparse(double v) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }
}

