/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.decompose;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrix;
import mikera.matrixx.decompose.ISVDResult;
import mikera.matrixx.decompose.impl.svd.SVDResult;
import mikera.matrixx.decompose.impl.svd.SvdImplicitQr;
import mikera.matrixx.impl.DiagonalMatrix;
import mikera.vectorz.AVector;

public class SVD {
    private SVD() {
    }

    public static ISVDResult decompose(AMatrix A) {
        return SvdImplicitQr.decompose(A, false);
    }

    public static ISVDResult decompose(AMatrix A, boolean compact) {
        return SvdImplicitQr.decompose(A, compact);
    }

    public static ISVDResult decomposeCompact(AMatrix A) {
        return SvdImplicitQr.decompose(A, true);
    }

    public static ISVDResult decomposeNonZero(AMatrix A) {
        ISVDResult svd = SVD.decomposeCompact(A);
        AVector svs = svd.getSingularValues();
        int m = A.rowCount();
        int n = A.columnCount();
        int s = svs.length();
        int svNumber = (int)svs.nonZeroCount();
        if (svNumber < s) {
            int[] ixs = new int[svNumber];
            int ix = 0;
            for (int i = 0; i < s; ++i) {
                if (svs.unsafeGet(i) == 0.0) continue;
                ixs[ix++] = i;
            }
            AVector newSvs = svs.selectClone(ixs);
            AMatrix U = svd.getU();
            AMatrix V = svd.getV();
            Matrix cU = Matrix.create(m, svNumber);
            Matrix cV = Matrix.create(n, svNumber);
            for (int i = 0; i < svNumber; ++i) {
                int si = ixs[i];
                ((AMatrix)cU).setColumn(i, U.getColumn(si));
                ((AMatrix)cV).setColumn(i, V.getColumn(si));
            }
            DiagonalMatrix cS = DiagonalMatrix.create(newSvs);
            return new SVDResult(cU, cS, cV, newSvs);
        }
        return svd;
    }
}

