/*
 * Decompiled with CFR 0.152.
 */
package mikera.example;

import mikera.matrixx.AMatrix;
import mikera.matrixx.impl.SparseRowMatrix;
import mikera.util.Random;
import mikera.vectorz.impl.SparseIndexedVector;

public class SparseArrays {
    public static final int SIZE = 1000000;
    private static Random r = new Random();

    public static SparseIndexedVector createRow() {
        SparseIndexedVector v = SparseIndexedVector.createLength(1000000);
        for (int i = 0; i < 1000; ++i) {
            v.set(r.nextInt(1000000), r.nextDouble());
        }
        return v;
    }

    public static SparseRowMatrix createMatrix() {
        SparseRowMatrix sm = SparseRowMatrix.create(1000000, 1000000);
        for (int i = 0; i < 1000; ++i) {
            sm.replaceRow(r.nextInt(1000000), SparseArrays.createRow());
        }
        return sm;
    }

    public static void main(String[] args) {
        SparseRowMatrix sm = SparseArrays.createMatrix();
        System.out.println(sm.nonZeroCount() + " elements are non-zero out of " + sm.elementCount() + " total elements");
        SparseRowMatrix smm = sm.innerProduct(sm);
        System.out.println(((AMatrix)smm).nonZeroCount() + " elements are non-zero in the product.");
    }
}

