/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz.impl;

import mikera.arrayz.INDArray;
import mikera.arrayz.impl.BaseShapedArray;
import mikera.arrayz.impl.ZeroArray;
import mikera.vectorz.Scalar;
import mikera.vectorz.Vectorz;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.IntArrays;

public class BroadcastScalarArray
extends BaseShapedArray {
    private static final long serialVersionUID = 4529531791977491726L;
    private final double value;
    private final int dims;
    private final INDArray majorSlice;

    private BroadcastScalarArray(double d, int[] targetShape) {
        super(targetShape);
        this.dims = targetShape.length;
        this.value = d;
        this.majorSlice = this.dims > 0 ? this.createMajorSlice() : null;
    }

    public static INDArray create(double value, int[] targetShape) {
        int tdims = targetShape.length;
        if (tdims == 0) {
            return Scalar.create(value);
        }
        if (tdims == 1) {
            return Vectorz.createRepeatedElement(targetShape[0], value);
        }
        if (tdims == 2) {
            return Vectorz.createRepeatedElement(targetShape[1], value).broadcast(targetShape);
        }
        if (value == 0.0) {
            return ZeroArray.create(targetShape);
        }
        return new BroadcastScalarArray(value, targetShape);
    }

    @Override
    public double get(int ... indexes) {
        return this.value;
    }

    @Override
    public void set(int[] indexes, double value) {
        throw new UnsupportedOperationException(ErrorMessages.immutable(this));
    }

    @Override
    public INDArray slice(int majorSlice) {
        if (majorSlice >= 0 && majorSlice < this.shape[0]) {
            return this.majorSlice;
        }
        throw new UnsupportedOperationException(ErrorMessages.invalidSlice(this, majorSlice));
    }

    private INDArray createMajorSlice() {
        if (this.dims > 0) {
            return BroadcastScalarArray.create(this.value, IntArrays.removeIndex(this.shape, 0));
        }
        throw new UnsupportedOperationException("Can't slice a scalar array");
    }

    @Override
    public INDArray slice(int dimension, int index) {
        if (dimension >= 0 && dimension < this.dims) {
            return BroadcastScalarArray.create(this.value, IntArrays.removeIndex(this.shape, dimension));
        }
        throw new UnsupportedOperationException(ErrorMessages.invalidSlice(this, dimension, index));
    }

    @Override
    public boolean isView() {
        return false;
    }

    @Override
    public boolean isFullyMutable() {
        return false;
    }

    @Override
    public double get() {
        if (this.dims == 0) {
            return this.value;
        }
        throw new IllegalArgumentException(ErrorMessages.invalidIndex((INDArray)this, new int[0]));
    }

    @Override
    public double get(int x) {
        if (this.dims == 0 && x >= 0 && x < this.shape[0]) {
            return this.value;
        }
        throw new IllegalArgumentException(ErrorMessages.invalidIndex((INDArray)this, x));
    }

    @Override
    public double get(int x, int y) {
        if (this.dims == 0 && x >= 0 && y >= 0 && x < this.shape[0] && y < this.shape[1]) {
            return this.value;
        }
        throw new IllegalArgumentException(ErrorMessages.invalidIndex((INDArray)this, x, y));
    }

    @Override
    public BroadcastScalarArray exactClone() {
        return new BroadcastScalarArray(this.value, this.shape);
    }
}

