/*
 * Decompiled with CFR 0.152.
 */
package mikera.arrayz.impl;

import mikera.arrayz.INDArray;
import mikera.arrayz.impl.AbstractArray;
import mikera.vectorz.Op2;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.IntArrays;

public abstract class BaseShapedArray
extends AbstractArray<INDArray> {
    private static final long serialVersionUID = -1486048632091493890L;
    protected final int[] shape;

    public BaseShapedArray(int[] shape) {
        this.shape = shape;
    }

    @Override
    public int dimensionality() {
        return this.shape.length;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public int[] getShapeClone() {
        return (int[])this.shape.clone();
    }

    @Override
    public int sliceCount() {
        return this.shape[0];
    }

    @Override
    public double reduce(Op2 op, double init) {
        if (this.shape.length == 0) {
            return op.apply(init, this.get());
        }
        double result = init;
        int n = this.sliceCount();
        for (int i = 0; i < n; ++i) {
            result = this.slice(i).reduce(op, result);
        }
        return result;
    }

    @Override
    public double reduce(Op2 op) {
        if (this.shape.length == 0) {
            return this.get();
        }
        return super.reduce(op);
    }

    @Override
    public boolean isZero() {
        if (this.dimensionality() == 0) {
            return this.get() == 0.0;
        }
        return super.isZero();
    }

    @Override
    public int getShape(int dim) {
        return this.shape[dim];
    }

    @Override
    public long elementCount() {
        return IntArrays.arrayProduct(this.shape);
    }

    @Override
    public double getElement(long i) {
        if (this.dimensionality() == 0) {
            if (i == 0L) {
                return this.get();
            }
            throw new IndexOutOfBoundsException(ErrorMessages.invalidElementIndex(this, i));
        }
        long sliceElementCount = this.slice(0).elementCount();
        if (sliceElementCount == 0L) {
            throw new IndexOutOfBoundsException(ErrorMessages.invalidElementIndex(this, i));
        }
        int slice = (int)(i / sliceElementCount);
        return this.slice(slice).getElement(i - (long)slice * sliceElementCount);
    }
}

