/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Arrays;
import org.ejml.EjmlParameters;
import org.ejml.alg.dense.decompose.lu.LUDecompositionAlt_CD64;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.misc.CTransposeAlgs;
import org.ejml.alg.dense.mult.CMatrixMatrixMult;
import org.ejml.data.CD1Matrix64F;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.CLinearSolverFactory;
import org.ejml.interfaces.linsol.LinearSolver;

public class CCommonOps {
    public static CDenseMatrix64F identity(int n) {
        CDenseMatrix64F cDenseMatrix64F = new CDenseMatrix64F(n, n);
        for (int i = 0; i < n; ++i) {
            cDenseMatrix64F.set(i, i, 1.0, 0.0);
        }
        return cDenseMatrix64F;
    }

    public static CDenseMatrix64F identity(int n, int n2) {
        CDenseMatrix64F cDenseMatrix64F = new CDenseMatrix64F(n, n2);
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            cDenseMatrix64F.set(i, i, 1.0, 0.0);
        }
        return cDenseMatrix64F;
    }

    public static CDenseMatrix64F diag(double ... dArray) {
        if (dArray.length % 2 == 1) {
            throw new IllegalArgumentException("must be an even number of arguments");
        }
        int n = dArray.length / 2;
        CDenseMatrix64F cDenseMatrix64F = new CDenseMatrix64F(n, n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            cDenseMatrix64F.set(i, i, dArray[n2++], dArray[n2++]);
        }
        return cDenseMatrix64F;
    }

    public static void convert(D1Matrix64F d1Matrix64F, CD1Matrix64F cD1Matrix64F) {
        if (d1Matrix64F.numCols != cD1Matrix64F.numCols || d1Matrix64F.numRows != cD1Matrix64F.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        Arrays.fill(cD1Matrix64F.data, 0, cD1Matrix64F.getDataLength(), 0.0);
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            cD1Matrix64F.data[i] = d1Matrix64F.data[i / 2];
        }
    }

    public static DenseMatrix64F stripReal(CD1Matrix64F cD1Matrix64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(cD1Matrix64F.numRows, cD1Matrix64F.numCols);
        } else if (cD1Matrix64F.numCols != denseMatrix64F.numCols || cD1Matrix64F.numRows != denseMatrix64F.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            denseMatrix64F.data[i / 2] = cD1Matrix64F.data[i];
        }
        return denseMatrix64F;
    }

    public static DenseMatrix64F stripImaginary(CD1Matrix64F cD1Matrix64F, DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(cD1Matrix64F.numRows, cD1Matrix64F.numCols);
        } else if (cD1Matrix64F.numCols != denseMatrix64F.numCols || cD1Matrix64F.numRows != denseMatrix64F.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 1; i < n; i += 2) {
            denseMatrix64F.data[i / 2] = cD1Matrix64F.data[i];
        }
        return denseMatrix64F;
    }

    public static void magnitude(CD1Matrix64F cD1Matrix64F, D1Matrix64F d1Matrix64F) {
        if (cD1Matrix64F.numCols != d1Matrix64F.numCols || cD1Matrix64F.numRows != d1Matrix64F.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            double d = cD1Matrix64F.data[i];
            double d2 = cD1Matrix64F.data[i + 1];
            d1Matrix64F.data[i / 2] = Math.sqrt(d * d + d2 * d2);
        }
    }

    public static void conjugate(CD1Matrix64F cD1Matrix64F, CD1Matrix64F cD1Matrix64F2) {
        if (cD1Matrix64F.numCols != cD1Matrix64F2.numCols || cD1Matrix64F.numRows != cD1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            cD1Matrix64F2.data[i] = cD1Matrix64F.data[i];
            cD1Matrix64F2.data[i + 1] = -cD1Matrix64F.data[i + 1];
        }
    }

    public static void fill(CD1Matrix64F cD1Matrix64F, double d, double d2) {
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            cD1Matrix64F.data[i] = d;
            cD1Matrix64F.data[i + 1] = d2;
        }
    }

    public static void add(CD1Matrix64F cD1Matrix64F, CD1Matrix64F cD1Matrix64F2, CD1Matrix64F cD1Matrix64F3) {
        if (cD1Matrix64F.numCols != cD1Matrix64F2.numCols || cD1Matrix64F.numRows != cD1Matrix64F2.numRows || cD1Matrix64F.numCols != cD1Matrix64F3.numCols || cD1Matrix64F.numRows != cD1Matrix64F3.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; ++i) {
            cD1Matrix64F3.data[i] = cD1Matrix64F.data[i] + cD1Matrix64F2.data[i];
        }
    }

    public static void subtract(CD1Matrix64F cD1Matrix64F, CD1Matrix64F cD1Matrix64F2, CD1Matrix64F cD1Matrix64F3) {
        if (cD1Matrix64F.numCols != cD1Matrix64F2.numCols || cD1Matrix64F.numRows != cD1Matrix64F2.numRows || cD1Matrix64F.numCols != cD1Matrix64F3.numCols || cD1Matrix64F.numRows != cD1Matrix64F3.numRows) {
            throw new IllegalArgumentException("The matrices are not all the same dimension.");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; ++i) {
            cD1Matrix64F3.data[i] = cD1Matrix64F.data[i] - cD1Matrix64F2.data[i];
        }
    }

    public static void mult(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F2.numCols >= EjmlParameters.CMULT_COLUMN_SWITCH) {
            CMatrixMatrixMult.mult_reorder(cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        } else {
            CMatrixMatrixMult.mult_small(cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        }
    }

    public static void mult(double d, double d2, CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F2.numCols >= EjmlParameters.CMULT_COLUMN_SWITCH) {
            CMatrixMatrixMult.mult_reorder(d, d2, cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        } else {
            CMatrixMatrixMult.mult_small(d, d2, cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        }
    }

    public static void multAdd(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F2.numCols >= EjmlParameters.MULT_COLUMN_SWITCH) {
            CMatrixMatrixMult.multAdd_reorder(cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        } else {
            CMatrixMatrixMult.multAdd_small(cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        }
    }

    public static void multAdd(double d, double d2, CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        if (cDenseMatrix64F2.numCols >= EjmlParameters.CMULT_COLUMN_SWITCH) {
            CMatrixMatrixMult.multAdd_reorder(d, d2, cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        } else {
            CMatrixMatrixMult.multAdd_small(d, d2, cDenseMatrix64F, cDenseMatrix64F2, cDenseMatrix64F3);
        }
    }

    public static void transpose(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numCols == cDenseMatrix64F.numRows) {
            CTransposeAlgs.square(cDenseMatrix64F);
        } else {
            CDenseMatrix64F cDenseMatrix64F2 = new CDenseMatrix64F(cDenseMatrix64F.numCols, cDenseMatrix64F.numRows);
            CCommonOps.transpose(cDenseMatrix64F, cDenseMatrix64F2);
            cDenseMatrix64F.reshape(cDenseMatrix64F2.numRows, cDenseMatrix64F2.numCols);
            cDenseMatrix64F.set(cDenseMatrix64F2);
        }
    }

    public static void transposeConjugate(CDenseMatrix64F cDenseMatrix64F) {
        if (cDenseMatrix64F.numCols == cDenseMatrix64F.numRows) {
            CTransposeAlgs.squareConjugate(cDenseMatrix64F);
        } else {
            CDenseMatrix64F cDenseMatrix64F2 = new CDenseMatrix64F(cDenseMatrix64F.numCols, cDenseMatrix64F.numRows);
            CCommonOps.transposeConjugate(cDenseMatrix64F, cDenseMatrix64F2);
            cDenseMatrix64F.reshape(cDenseMatrix64F2.numRows, cDenseMatrix64F2.numCols);
            cDenseMatrix64F.set(cDenseMatrix64F2);
        }
    }

    public static CDenseMatrix64F transpose(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2) {
        if (cDenseMatrix64F2 == null) {
            cDenseMatrix64F2 = new CDenseMatrix64F(cDenseMatrix64F.numCols, cDenseMatrix64F.numRows);
        } else if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows || cDenseMatrix64F.numRows != cDenseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Input and output shapes are not compatible");
        }
        CTransposeAlgs.standard(cDenseMatrix64F, cDenseMatrix64F2);
        return cDenseMatrix64F2;
    }

    public static CDenseMatrix64F transposeConjugate(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2) {
        if (cDenseMatrix64F2 == null) {
            cDenseMatrix64F2 = new CDenseMatrix64F(cDenseMatrix64F.numCols, cDenseMatrix64F.numRows);
        } else if (cDenseMatrix64F.numCols != cDenseMatrix64F2.numRows || cDenseMatrix64F.numRows != cDenseMatrix64F2.numCols) {
            throw new IllegalArgumentException("Input and output shapes are not compatible");
        }
        CTransposeAlgs.standardConjugate(cDenseMatrix64F, cDenseMatrix64F2);
        return cDenseMatrix64F2;
    }

    public static boolean invert(CDenseMatrix64F cDenseMatrix64F) {
        LinearSolver<CDenseMatrix64F> linearSolver = CLinearSolverFactory.lu(cDenseMatrix64F.numRows);
        if (!linearSolver.setA(cDenseMatrix64F)) {
            return false;
        }
        linearSolver.invert(cDenseMatrix64F);
        return true;
    }

    public static boolean invert(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2) {
        LinearSolver<CDenseMatrix64F> linearSolver = CLinearSolverFactory.lu(cDenseMatrix64F.numRows);
        if (linearSolver.modifiesA()) {
            cDenseMatrix64F = cDenseMatrix64F.copy();
        }
        if (!linearSolver.setA(cDenseMatrix64F)) {
            return false;
        }
        linearSolver.invert(cDenseMatrix64F2);
        return true;
    }

    public static boolean solve(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F cDenseMatrix64F2, CDenseMatrix64F cDenseMatrix64F3) {
        LinearSolver<CDenseMatrix64F> linearSolver = cDenseMatrix64F.numCols == cDenseMatrix64F.numRows ? CLinearSolverFactory.lu(cDenseMatrix64F.numRows) : CLinearSolverFactory.qr(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        if (!(linearSolver = new LinearSolverSafe<CDenseMatrix64F>(linearSolver)).setA(cDenseMatrix64F)) {
            return false;
        }
        linearSolver.solve(cDenseMatrix64F2, cDenseMatrix64F3);
        return true;
    }

    public static Complex64F det(CDenseMatrix64F cDenseMatrix64F) {
        LUDecompositionAlt_CD64 lUDecompositionAlt_CD64 = new LUDecompositionAlt_CD64();
        if (lUDecompositionAlt_CD64.inputModified()) {
            cDenseMatrix64F = cDenseMatrix64F.copy();
        }
        if (!lUDecompositionAlt_CD64.decompose(cDenseMatrix64F)) {
            return new Complex64F();
        }
        return lUDecompositionAlt_CD64.computeDeterminant();
    }

    public static void elementMultiply(CD1Matrix64F cD1Matrix64F, double d, double d2, CD1Matrix64F cD1Matrix64F2) {
        if (cD1Matrix64F.numCols != cD1Matrix64F2.numCols || cD1Matrix64F.numRows != cD1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'input' and 'output' matrices do not have compatible dimensions");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            double d3 = cD1Matrix64F.data[i];
            double d4 = cD1Matrix64F.data[i + 1];
            cD1Matrix64F2.data[i] = d3 * d - d4 * d2;
            cD1Matrix64F2.data[i + 1] = d3 * d2 + d4 * d;
        }
    }

    public static void elementDivide(CD1Matrix64F cD1Matrix64F, double d, double d2, CD1Matrix64F cD1Matrix64F2) {
        if (cD1Matrix64F.numCols != cD1Matrix64F2.numCols || cD1Matrix64F.numRows != cD1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'input' and 'output' matrices do not have compatible dimensions");
        }
        double d3 = d * d + d2 * d2;
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            double d4 = cD1Matrix64F.data[i];
            double d5 = cD1Matrix64F.data[i + 1];
            cD1Matrix64F2.data[i] = (d4 * d + d5 * d2) / d3;
            cD1Matrix64F2.data[i + 1] = (d5 * d - d4 * d2) / d3;
        }
    }

    public static void elementDivide(double d, double d2, CD1Matrix64F cD1Matrix64F, CD1Matrix64F cD1Matrix64F2) {
        if (cD1Matrix64F.numCols != cD1Matrix64F2.numCols || cD1Matrix64F.numRows != cD1Matrix64F2.numRows) {
            throw new IllegalArgumentException("The 'input' and 'output' matrices do not have compatible dimensions");
        }
        int n = cD1Matrix64F.getDataLength();
        for (int i = 0; i < n; i += 2) {
            double d3 = cD1Matrix64F.data[i];
            double d4 = cD1Matrix64F.data[i + 1];
            double d5 = d3 * d3 + d4 * d4;
            cD1Matrix64F2.data[i] = (d * d3 + d2 * d4) / d5;
            cD1Matrix64F2.data[i + 1] = (d2 * d3 - d * d4) / d5;
        }
    }

    public static double elementMinReal(CD1Matrix64F cD1Matrix64F) {
        int n = cD1Matrix64F.getDataLength();
        double d = cD1Matrix64F.data[0];
        for (int i = 2; i < n; i += 2) {
            double d2 = cD1Matrix64F.data[i];
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double elementMinImaginary(CD1Matrix64F cD1Matrix64F) {
        int n = cD1Matrix64F.getDataLength();
        double d = cD1Matrix64F.data[1];
        for (int i = 3; i < n; i += 2) {
            double d2 = cD1Matrix64F.data[i];
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double elementMaxReal(CD1Matrix64F cD1Matrix64F) {
        int n = cD1Matrix64F.getDataLength();
        double d = cD1Matrix64F.data[0];
        for (int i = 2; i < n; i += 2) {
            double d2 = cD1Matrix64F.data[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double elementMaxImaginary(CD1Matrix64F cD1Matrix64F) {
        int n = cD1Matrix64F.getDataLength();
        double d = cD1Matrix64F.data[1];
        for (int i = 3; i < n; i += 2) {
            double d2 = cD1Matrix64F.data[i];
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double elementMaxMagnitude2(CD1Matrix64F cD1Matrix64F) {
        int n = cD1Matrix64F.getDataLength();
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d2 = cD1Matrix64F.data[n2++];
            int n3 = n2++;
            double d3 = cD1Matrix64F.data[n3];
            double d4 = d2 * d2 + d3 * d3;
            if (!(d4 > d)) continue;
            d = d4;
        }
        return d;
    }

    public static void setIdentity(CDenseMatrix64F cDenseMatrix64F) {
        int n = cDenseMatrix64F.numRows < cDenseMatrix64F.numCols ? cDenseMatrix64F.numRows : cDenseMatrix64F.numCols;
        Arrays.fill(cDenseMatrix64F.data, 0, cDenseMatrix64F.getDataLength(), 0.0);
        int n2 = 0;
        int n3 = cDenseMatrix64F.getRowStride();
        int n4 = 0;
        while (n4 < n) {
            cDenseMatrix64F.data[n2] = 1.0;
            ++n4;
            n2 += n3 + 2;
        }
    }

    public static CDenseMatrix64F extract(CDenseMatrix64F cDenseMatrix64F, int n, int n2, int n3, int n4) {
        if (n2 <= n || n < 0 || n2 > cDenseMatrix64F.numRows) {
            throw new IllegalArgumentException("srcY1 <= srcY0 || srcY0 < 0 || srcY1 > src.numRows");
        }
        if (n4 <= n3 || n3 < 0 || n4 > cDenseMatrix64F.numCols) {
            throw new IllegalArgumentException("srcX1 <= srcX0 || srcX0 < 0 || srcX1 > src.numCols");
        }
        int n5 = n4 - n3;
        int n6 = n2 - n;
        CDenseMatrix64F cDenseMatrix64F2 = new CDenseMatrix64F(n6, n5);
        CCommonOps.extract(cDenseMatrix64F, n, n2, n3, n4, cDenseMatrix64F2, 0, 0);
        return cDenseMatrix64F2;
    }

    public static void extract(CDenseMatrix64F cDenseMatrix64F, int n, int n2, int n3, int n4, CDenseMatrix64F cDenseMatrix64F2, int n5, int n6) {
        int n7 = n2 - n;
        int n8 = (n4 - n3) * 2;
        for (int i = 0; i < n7; ++i) {
            int n9 = cDenseMatrix64F.getIndex(i + n, n3);
            int n10 = cDenseMatrix64F2.getIndex(i + n5, n6);
            System.arraycopy(cDenseMatrix64F.data, n9, cDenseMatrix64F2.data, n10, n8);
        }
    }

    public static CDenseMatrix64F[] columnsToVector(CDenseMatrix64F cDenseMatrix64F, CDenseMatrix64F[] cDenseMatrix64FArray) {
        CDenseMatrix64F[] cDenseMatrix64FArray2 = cDenseMatrix64FArray == null || cDenseMatrix64FArray.length < cDenseMatrix64F.numCols ? new CDenseMatrix64F[cDenseMatrix64F.numCols] : cDenseMatrix64FArray;
        for (int i = 0; i < cDenseMatrix64FArray2.length; ++i) {
            if (cDenseMatrix64FArray2[i] == null) {
                cDenseMatrix64FArray2[i] = new CDenseMatrix64F(cDenseMatrix64F.numRows, 1);
            } else {
                cDenseMatrix64FArray2[i].reshape(cDenseMatrix64F.numRows, 1);
            }
            CDenseMatrix64F cDenseMatrix64F2 = cDenseMatrix64FArray2[i];
            int n = 0;
            for (int j = 0; j < cDenseMatrix64F.numRows; ++j) {
                int n2 = cDenseMatrix64F.getIndex(j, i);
                cDenseMatrix64F2.data[n++] = cDenseMatrix64F.data[n2++];
                cDenseMatrix64F2.data[n++] = cDenseMatrix64F.data[n2];
            }
        }
        return cDenseMatrix64FArray2;
    }

    public static double elementMaxAbs(CDenseMatrix64F cDenseMatrix64F) {
        int n = cDenseMatrix64F.getDataLength();
        double d = 0.0;
        for (int i = 0; i < n; i += 2) {
            double d2 = cDenseMatrix64F.data[i];
            double d3 = cDenseMatrix64F.data[i + 1];
            double d4 = d2 * d2 + d3 * d3;
            if (!(d4 > d)) continue;
            d = d4;
        }
        return Math.sqrt(d);
    }
}

