/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.util.Iterator;
import org.ejml.data.D1Matrix64F;

public class MatrixIterator64F
implements Iterator<Double> {
    private D1Matrix64F a;
    private boolean rowMajor;
    private int minCol;
    private int minRow;
    private int index = 0;
    private int size;
    private int submatrixStride;
    int subRow;
    int subCol;

    public MatrixIterator64F(D1Matrix64F d1Matrix64F, boolean bl, int n, int n2, int n3, int n4) {
        if (n4 < n2) {
            throw new IllegalArgumentException("maxCol has to be more than or equal to minCol");
        }
        if (n3 < n) {
            throw new IllegalArgumentException("maxRow has to be more than or equal to minCol");
        }
        if (n4 >= d1Matrix64F.numCols) {
            throw new IllegalArgumentException("maxCol must be < numCols");
        }
        if (n3 >= d1Matrix64F.numRows) {
            throw new IllegalArgumentException("maxRow must be < numCRows");
        }
        this.a = d1Matrix64F;
        this.rowMajor = bl;
        this.minCol = n2;
        this.minRow = n;
        this.size = (n4 - n2 + 1) * (n3 - n + 1);
        this.submatrixStride = bl ? n4 - n2 + 1 : n3 - n + 1;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public Double next() {
        if (this.rowMajor) {
            this.subRow = this.index / this.submatrixStride;
            this.subCol = this.index % this.submatrixStride;
        } else {
            this.subRow = this.index % this.submatrixStride;
            this.subCol = this.index / this.submatrixStride;
        }
        ++this.index;
        return this.a.get(this.subRow + this.minRow, this.subCol + this.minCol);
    }

    @Override
    public void remove() {
        throw new RuntimeException("Operation not supported");
    }

    public int getIndex() {
        return this.index - 1;
    }

    public boolean isRowMajor() {
        return this.rowMajor;
    }

    public void set(double d) {
        this.a.set(this.subRow + this.minRow, this.subCol + this.minCol, d);
    }
}

