/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.EjmlParameters;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.ReshapeMatrix;
import org.ejml.ops.MatrixIO;

public class BlockD3Matrix64F
implements ReshapeMatrix,
RealMatrix64F {
    public int blockLength;
    public double[][][] blocks;
    public int numRows;
    public int numCols;

    public BlockD3Matrix64F(int n, int n2, int n3) {
        this.blockLength = n3;
        this.reshape(n, n2);
    }

    public BlockD3Matrix64F(int n, int n2) {
        this(n, n2, EjmlParameters.BLOCK_WIDTH);
    }

    public double[][][] getData() {
        return this.blocks;
    }

    @Override
    public void reshape(int n, int n2) {
        this.numRows = n;
        this.numCols = n2;
        int n3 = n / this.blockLength;
        int n4 = n2 / this.blockLength;
        if (n % this.blockLength > 0) {
            ++n3;
        }
        if (n2 % this.blockLength > 0) {
            ++n4;
        }
        this.blocks = new double[n3][n4][];
        for (int i = 0; i < n; i += this.blockLength) {
            int n5 = i / this.blockLength;
            for (int j = 0; j < n2; j += this.blockLength) {
                int n6 = j / this.blockLength;
                this.blocks[n5][n6] = new double[this.blockLength * this.blockLength];
            }
        }
    }

    @Override
    public double get(int n, int n2) {
        int n3 = n / this.blockLength;
        int n4 = n2 / this.blockLength;
        int n5 = n % this.blockLength;
        int n6 = n2 % this.blockLength;
        int n7 = n5 * this.blockLength + n6;
        return this.blocks[n3][n4][n7];
    }

    @Override
    public void set(int n, int n2, double d) {
        int n3 = n / this.blockLength;
        int n4 = n2 / this.blockLength;
        int n5 = n % this.blockLength;
        int n6 = n2 % this.blockLength;
        int n7 = n5 * this.blockLength + n6;
        this.blocks[n3][n4][n7] = d;
    }

    @Override
    public double unsafe_get(int n, int n2) {
        return this.get(n, n2);
    }

    @Override
    public void unsafe_set(int n, int n2, double d) {
        this.set(n, n2, d);
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    @Override
    public void print() {
        MatrixIO.print(System.out, this);
    }

    @Override
    public <T extends Matrix> T copy() {
        return null;
    }

    @Override
    public void set(Matrix matrix) {
        throw new RuntimeException("Not supported yet");
    }
}

