/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decomposition.qr.QRDecompositionHouseholderColumn_D64;
import org.ejml.alg.dense.decomposition.qr.QrUpdate;
import org.ejml.alg.dense.linsol.AdjustableLinearSolver;
import org.ejml.alg.dense.linsol.qr.LinearSolverQr_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class AdjLinearSolverQr_D64
extends LinearSolverQr_D64
implements AdjustableLinearSolver {
    private QrUpdate update;
    private DenseMatrix64F A;

    public AdjLinearSolverQr_D64() {
        super(new QRDecompositionHouseholderColumn_D64());
    }

    @Override
    public void setMaxSize(int n, int n2) {
        super.setMaxSize(n += 5, n2);
        this.update = new QrUpdate(n, n2, true);
        this.A = new DenseMatrix64F(n, n2);
    }

    @Override
    public DenseMatrix64F getA() {
        if (this.A.data.length < this.numRows * this.numCols) {
            this.A = new DenseMatrix64F(this.numRows, this.numCols);
        }
        this.A.reshape(this.numRows, this.numCols, false);
        CommonOps.mult(this.Q, this.R, this.A);
        return this.A;
    }

    @Override
    public boolean addRowToA(double[] dArray, int n) {
        if (this.numRows + 1 > this.maxRows) {
            int n2 = this.maxRows / 10;
            if (n2 < 1) {
                n2 = 1;
            }
            this.maxRows = this.numRows + n2;
            this.Q.reshape(this.maxRows, this.maxRows, true);
            this.R.reshape(this.maxRows, this.maxCols, true);
        }
        this.update.addRow(this.Q, this.R, dArray, n, true);
        ++this.numRows;
        return true;
    }

    @Override
    public boolean removeRowFromA(int n) {
        this.update.deleteRow(this.Q, this.R, n, true);
        --this.numRows;
        return true;
    }
}

