/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.chol;

import org.ejml.alg.dense.decomposition.TriangularSolver;
import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionCommon_D64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.ops.SpecializedOps;

public class LinearSolverChol_D64
extends LinearSolverAbstract_D64 {
    CholeskyDecompositionCommon_D64 decomposer;
    int n;
    double[] vv;
    double[] t;

    public LinearSolverChol_D64(CholeskyDecompositionCommon_D64 choleskyDecompositionCommon_D64) {
        this.decomposer = choleskyDecompositionCommon_D64;
    }

    @Override
    public boolean setA(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("Matrix must be square");
        }
        this._setA(denseMatrix64F);
        if (this.decomposer.decompose(denseMatrix64F)) {
            this.n = denseMatrix64F.numCols;
            this.vv = this.decomposer._getVV();
            this.t = this.decomposer.getT().data;
            return true;
        }
        return false;
    }

    @Override
    public double quality() {
        return SpecializedOps.qualityTriangular(this.decomposer.getT());
    }

    @Override
    public void solve(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F.numCols != denseMatrix64F2.numCols || denseMatrix64F.numRows != this.n || denseMatrix64F2.numRows != this.n) {
            throw new IllegalArgumentException("Unexpected matrix size");
        }
        int n = denseMatrix64F.numCols;
        double[] dArray = denseMatrix64F.data;
        double[] dArray2 = denseMatrix64F2.data;
        if (this.decomposer.isLower()) {
            for (int i = 0; i < n; ++i) {
                int n2;
                for (n2 = 0; n2 < this.n; ++n2) {
                    this.vv[n2] = dArray[n2 * n + i];
                }
                this.solveInternalL();
                for (n2 = 0; n2 < this.n; ++n2) {
                    dArray2[n2 * n + i] = this.vv[n2];
                }
            }
        } else {
            throw new RuntimeException("Implement");
        }
    }

    private void solveInternalL() {
        TriangularSolver.solveL(this.t, this.vv, this.n);
        TriangularSolver.solveTranL(this.t, this.vv, this.n);
    }

    @Override
    public void invert(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows != this.n || denseMatrix64F.numCols != this.n) {
            throw new RuntimeException("Unexpected matrix dimension");
        }
        if (denseMatrix64F.data == this.t) {
            throw new IllegalArgumentException("Passing in the same matrix that was decomposed.");
        }
        double[] dArray = denseMatrix64F.data;
        if (!this.decomposer.isLower()) {
            throw new RuntimeException("Implement");
        }
        this.setToInverseL(dArray);
    }

    public void setToInverseL(double[] dArray) {
        int n;
        double d;
        int n2;
        double d2;
        int n3;
        for (n3 = 0; n3 < this.n; ++n3) {
            d2 = this.t[n3 * this.n + n3];
            for (n2 = 0; n2 <= n3; ++n2) {
                d = n3 == n2 ? 1.0 : 0.0;
                for (n = n3 - 1; n >= n2; --n) {
                    d -= this.t[n3 * this.n + n] * dArray[n2 * this.n + n];
                }
                dArray[n2 * this.n + n3] = d / d2;
            }
        }
        for (n3 = this.n - 1; n3 >= 0; --n3) {
            d2 = this.t[n3 * this.n + n3];
            for (n2 = 0; n2 <= n3; ++n2) {
                d = n3 < n2 ? 0.0 : dArray[n2 * this.n + n3];
                for (n = n3 + 1; n < this.n; ++n) {
                    d -= this.t[n * this.n + n3] * dArray[n2 * this.n + n];
                }
                double d3 = d / d2;
                dArray[n2 * this.n + n3] = d3;
                dArray[n3 * this.n + n2] = d3;
            }
        }
    }

    @Override
    public boolean modifiesA() {
        return this.decomposer.inputModified();
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public CholeskyDecomposition<DenseMatrix64F> getDecomposition() {
        return this.decomposer;
    }
}

