/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions_D64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CommonOps;

public class QRDecompositionHouseholderColumn_D64
implements QRDecomposition<DenseMatrix64F> {
    protected double[][] dataQR;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] gammas;
    protected double gamma;
    protected double tau;
    protected boolean error;

    public void setExpectedMaxSize(int n, int n2) {
        this.numCols = n2;
        this.numRows = n;
        this.minLength = Math.min(n2, n);
        int n3 = Math.max(n2, n);
        if (this.dataQR == null || this.dataQR.length < n2 || this.dataQR[0].length < n) {
            this.dataQR = new double[n2][n];
            this.v = new double[n3];
            this.gammas = new double[this.minLength];
        }
        if (this.v.length < n3) {
            this.v = new double[n3];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public double[][] getQR() {
        return this.dataQR;
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (bl) {
            if (denseMatrix64F == null) {
                denseMatrix64F = CommonOps.identity(this.numRows, this.minLength);
            } else {
                if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CommonOps.setIdentity(denseMatrix64F);
            }
        } else if (denseMatrix64F == null) {
            denseMatrix64F = CommonOps.identity(this.numRows);
        } else {
            if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CommonOps.setIdentity(denseMatrix64F);
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            double[] dArray = this.dataQR[i];
            double d = dArray[i];
            dArray[i] = 1.0;
            QrHelperFunctions_D64.rank1UpdateMultR(denseMatrix64F, dArray, this.gammas[i], i, i, this.numRows, this.v);
            dArray[i] = d;
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getR(DenseMatrix64F denseMatrix64F, boolean bl) {
        int n;
        int n2;
        if (denseMatrix64F == null) {
            denseMatrix64F = bl ? new DenseMatrix64F(this.minLength, this.numCols) : new DenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (bl) {
                if (denseMatrix64F.numCols != this.numCols || denseMatrix64F.numRows != this.minLength) {
                    throw new IllegalArgumentException("Unexpected dimensions: found( " + denseMatrix64F.numRows + " " + denseMatrix64F.numCols + " ) expected( " + this.minLength + " " + this.numCols + " )");
                }
            } else if (denseMatrix64F.numCols != this.numCols || denseMatrix64F.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            for (n2 = 0; n2 < denseMatrix64F.numRows; ++n2) {
                int n3 = Math.min(n2, denseMatrix64F.numCols);
                for (n = 0; n < n3; ++n) {
                    denseMatrix64F.set(n2, n, 0.0);
                }
            }
        }
        for (n2 = 0; n2 < this.numCols; ++n2) {
            double[] dArray = this.dataQR[n2];
            n = Math.min(n2, this.numRows - 1);
            for (int i = 0; i <= n; ++i) {
                double d = dArray[i];
                denseMatrix64F.set(i, n2, d);
            }
        }
        return denseMatrix64F;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.setExpectedMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        this.convertToColumnMajor(denseMatrix64F);
        this.error = false;
        for (int i = 0; i < this.minLength; ++i) {
            this.householder(i);
            this.updateA(i);
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void convertToColumnMajor(DenseMatrix64F denseMatrix64F) {
        for (int i = 0; i < this.numCols; ++i) {
            double[] dArray = this.dataQR[i];
            for (int j = 0; j < this.numRows; ++j) {
                dArray[j] = denseMatrix64F.data[j * this.numCols + i];
            }
        }
    }

    protected void householder(int n) {
        double[] dArray = this.dataQR[n];
        double d = QrHelperFunctions_D64.findMax(dArray, n, this.numRows - n);
        if (d == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.tau = QrHelperFunctions_D64.computeTauAndDivide(n, this.numRows, dArray, d);
            double d2 = dArray[n] + this.tau;
            QrHelperFunctions_D64.divideElements(n + 1, this.numRows, dArray, d2);
            this.gamma = d2 / this.tau;
            this.tau *= d;
            dArray[n] = -this.tau;
        }
        this.gammas[n] = this.gamma;
    }

    protected void updateA(int n) {
        double[] dArray = this.dataQR[n];
        for (int i = n + 1; i < this.numCols; ++i) {
            int n2;
            double[] dArray2 = this.dataQR[i];
            double d = dArray2[n];
            for (n2 = n + 1; n2 < this.numRows; ++n2) {
                d += dArray[n2] * dArray2[n2];
            }
            int n3 = n;
            dArray2[n3] = dArray2[n3] - (d *= this.gamma);
            for (n2 = n + 1; n2 < this.numRows; ++n2) {
                int n4 = n2;
                dArray2[n4] = dArray2[n4] - dArray[n2] * d;
            }
        }
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

