/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig;

import org.ejml.alg.dense.decomposition.eig.symm.SymmetricQREigenHelper;
import org.ejml.alg.dense.decomposition.eig.symm.SymmetricQrAlgorithm;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.decomposition.TridiagonalSimilarDecomposition;
import org.ejml.ops.CommonOps;

public class SymmetricQRAlgorithmDecomposition_D64
implements EigenDecomposition<DenseMatrix64F> {
    private TridiagonalSimilarDecomposition<DenseMatrix64F> decomp;
    private SymmetricQREigenHelper helper;
    private SymmetricQrAlgorithm vector;
    private boolean computeVectorsWithValues = false;
    private double[] values;
    private double[] diag;
    private double[] off;
    private double[] diagSaved;
    private double[] offSaved;
    private DenseMatrix64F V;
    private DenseMatrix64F[] eigenvectors;
    boolean computeVectors;

    public SymmetricQRAlgorithmDecomposition_D64(TridiagonalSimilarDecomposition<DenseMatrix64F> tridiagonalSimilarDecomposition, boolean bl) {
        this.decomp = tridiagonalSimilarDecomposition;
        this.computeVectors = bl;
        this.helper = new SymmetricQREigenHelper();
        this.vector = new SymmetricQrAlgorithm(this.helper);
    }

    public SymmetricQRAlgorithmDecomposition_D64(boolean bl) {
        this(DecompositionFactory.tridiagonal(0), bl);
    }

    public void setComputeVectorsWithValues(boolean bl) {
        if (!this.computeVectors) {
            throw new IllegalArgumentException("Compute eigenvalues has been set to false");
        }
        this.computeVectorsWithValues = bl;
    }

    public void setMaxIterations(int n) {
        this.vector.setMaxIterations(n);
    }

    @Override
    public int getNumberOfEigenvalues() {
        return this.helper.getMatrixSize();
    }

    @Override
    public Complex64F getEigenvalue(int n) {
        return new Complex64F(this.values[n], 0.0);
    }

    @Override
    public DenseMatrix64F getEigenVector(int n) {
        return this.eigenvectors[n];
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numCols != denseMatrix64F.numRows) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        if (denseMatrix64F.numCols <= 0) {
            return false;
        }
        int n = denseMatrix64F.numRows;
        if (!this.decomp.decompose(denseMatrix64F)) {
            return false;
        }
        if (this.diag == null || this.diag.length < n) {
            this.diag = new double[n];
            this.off = new double[n - 1];
        }
        this.decomp.getDiagonal(this.diag, this.off);
        this.helper.init(this.diag, this.off, n);
        if (this.computeVectors) {
            if (this.computeVectorsWithValues) {
                return this.extractTogether();
            }
            return this.extractSeparate(n);
        }
        return this.computeEigenValues();
    }

    @Override
    public boolean inputModified() {
        return this.decomp.inputModified();
    }

    private boolean extractTogether() {
        this.V = this.decomp.getQ(this.V, true);
        this.helper.setQ(this.V);
        this.vector.setFastEigenvalues(false);
        if (!this.vector.process(-1, null, null)) {
            return false;
        }
        this.eigenvectors = CommonOps.rowsToVector(this.V, this.eigenvectors);
        this.values = this.helper.copyEigenvalues(this.values);
        return true;
    }

    private boolean extractSeparate(int n) {
        if (!this.computeEigenValues()) {
            return false;
        }
        this.helper.reset(n);
        this.diagSaved = this.helper.swapDiag(this.diagSaved);
        this.offSaved = this.helper.swapOff(this.offSaved);
        this.V = this.decomp.getQ(this.V, true);
        this.vector.setQ(this.V);
        if (!this.vector.process(-1, null, null, this.values)) {
            return false;
        }
        this.values = this.helper.copyEigenvalues(this.values);
        this.eigenvectors = CommonOps.rowsToVector(this.V, this.eigenvectors);
        return true;
    }

    private boolean computeEigenValues() {
        this.diagSaved = this.helper.copyDiag(this.diagSaved);
        this.offSaved = this.helper.copyOff(this.offSaved);
        this.vector.setQ(null);
        this.vector.setFastEigenvalues(true);
        if (!this.vector.process(-1, null, null)) {
            return false;
        }
        this.values = this.helper.copyEigenvalues(this.values);
        return true;
    }
}

