/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decompose.qr;

import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.ops.CCommonOps;

public class QRDecompositionHouseholderColumn_CD64
implements QRDecomposition<CDenseMatrix64F> {
    protected double[][] dataQR;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] gammas;
    protected double gamma;
    protected Complex64F tau = new Complex64F();
    protected boolean error;

    public void setExpectedMaxSize(int n, int n2) {
        this.numCols = n2;
        this.numRows = n;
        this.minLength = Math.min(n2, n);
        int n3 = Math.max(n2, n);
        if (this.dataQR == null || this.dataQR.length < n2 || this.dataQR[0].length < n * 2) {
            this.dataQR = new double[n2][n * 2];
            this.v = new double[n3 * 2];
            this.gammas = new double[this.minLength];
        }
        if (this.v.length < n3 * 2) {
            this.v = new double[n3 * 2];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public double[][] getQR() {
        return this.dataQR;
    }

    @Override
    public CDenseMatrix64F getQ(CDenseMatrix64F cDenseMatrix64F, boolean bl) {
        if (bl) {
            if (cDenseMatrix64F == null) {
                cDenseMatrix64F = CCommonOps.identity(this.numRows, this.minLength);
            } else {
                if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CCommonOps.setIdentity(cDenseMatrix64F);
            }
        } else if (cDenseMatrix64F == null) {
            cDenseMatrix64F = CCommonOps.identity(this.numRows);
        } else {
            if (cDenseMatrix64F.numRows != this.numRows || cDenseMatrix64F.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CCommonOps.setIdentity(cDenseMatrix64F);
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            double[] dArray = this.dataQR[i];
            double d = dArray[i * 2];
            double d2 = dArray[i * 2 + 1];
            dArray[i * 2] = 1.0;
            dArray[i * 2 + 1] = 0.0;
            double d3 = this.gammas[i];
            QrHelperFunctions_CD64.rank1UpdateMultR(cDenseMatrix64F, dArray, 0, d3, i, i, this.numRows, this.v);
            dArray[i * 2] = d;
            dArray[i * 2 + 1] = d2;
        }
        return cDenseMatrix64F;
    }

    @Override
    public CDenseMatrix64F getR(CDenseMatrix64F cDenseMatrix64F, boolean bl) {
        int n;
        int n2;
        if (cDenseMatrix64F == null) {
            cDenseMatrix64F = bl ? new CDenseMatrix64F(this.minLength, this.numCols) : new CDenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (bl) {
                if (cDenseMatrix64F.numCols != this.numCols || cDenseMatrix64F.numRows != this.minLength) {
                    throw new IllegalArgumentException("Unexpected dimensions: found( " + cDenseMatrix64F.numRows + " " + cDenseMatrix64F.numCols + " ) expected( " + this.minLength + " " + this.numCols + " )");
                }
            } else if (cDenseMatrix64F.numCols != this.numCols || cDenseMatrix64F.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            for (n2 = 0; n2 < cDenseMatrix64F.numRows; ++n2) {
                int n3 = Math.min(n2, cDenseMatrix64F.numCols);
                for (n = 0; n < n3; ++n) {
                    cDenseMatrix64F.set(n2, n, 0.0, 0.0);
                }
            }
        }
        for (n2 = 0; n2 < this.numCols; ++n2) {
            double[] dArray = this.dataQR[n2];
            n = Math.min(n2, this.numRows - 1);
            for (int i = 0; i <= n; ++i) {
                cDenseMatrix64F.set(i, n2, dArray[i * 2], dArray[i * 2 + 1]);
            }
        }
        return cDenseMatrix64F;
    }

    @Override
    public boolean decompose(CDenseMatrix64F cDenseMatrix64F) {
        this.setExpectedMaxSize(cDenseMatrix64F.numRows, cDenseMatrix64F.numCols);
        this.convertToColumnMajor(cDenseMatrix64F);
        this.error = false;
        for (int i = 0; i < this.minLength; ++i) {
            this.householder(i);
            this.updateA(i);
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void convertToColumnMajor(CDenseMatrix64F cDenseMatrix64F) {
        for (int i = 0; i < this.numCols; ++i) {
            double[] dArray = this.dataQR[i];
            int n = 0;
            for (int j = 0; j < this.numRows; ++j) {
                int n2 = (j * this.numCols + i) * 2;
                dArray[n++] = cDenseMatrix64F.data[n2];
                dArray[n++] = cDenseMatrix64F.data[n2 + 1];
            }
        }
    }

    protected void householder(int n) {
        double[] dArray = this.dataQR[n];
        double d = QrHelperFunctions_CD64.findMax(dArray, n, this.numRows - n);
        if (d == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.gamma = QrHelperFunctions_CD64.computeTauGammaAndDivide(n, this.numRows, dArray, d, this.tau);
            double d2 = dArray[n * 2] + this.tau.real;
            double d3 = dArray[n * 2 + 1] + this.tau.imaginary;
            QrHelperFunctions_CD64.divideElements(n + 1, this.numRows, dArray, 0, d2, d3);
            this.tau.real *= d;
            this.tau.imaginary *= d;
            dArray[n * 2] = -this.tau.real;
            dArray[n * 2 + 1] = -this.tau.imaginary;
        }
        this.gammas[n] = this.gamma;
    }

    protected void updateA(int n) {
        double[] dArray = this.dataQR[n];
        for (int i = n + 1; i < this.numCols; ++i) {
            double d;
            double d2;
            int n2;
            double[] dArray2 = this.dataQR[i];
            double d3 = dArray2[n * 2];
            double d4 = dArray2[n * 2 + 1];
            for (n2 = n + 1; n2 < this.numRows; ++n2) {
                d2 = dArray[n2 * 2];
                d = -dArray[n2 * 2 + 1];
                double d5 = dArray2[n2 * 2];
                double d6 = dArray2[n2 * 2 + 1];
                d3 += d2 * d5 - d * d6;
                d4 += d * d5 + d2 * d6;
            }
            int n3 = n * 2;
            dArray2[n3] = dArray2[n3] - (d3 *= this.gamma);
            int n4 = n * 2 + 1;
            dArray2[n4] = dArray2[n4] - (d4 *= this.gamma);
            for (n2 = n + 1; n2 < this.numRows; ++n2) {
                d2 = dArray[n2 * 2];
                d = dArray[n2 * 2 + 1];
                int n5 = n2 * 2;
                dArray2[n5] = dArray2[n5] - (d2 * d3 - d * d4);
                int n6 = n2 * 2 + 1;
                dArray2[n6] = dArray2[n6] - (d * d3 + d2 * d4);
            }
        }
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

