/*
 * Decompiled with CFR 0.152.
 */
package edu.mas.kern;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LIST<C> {
    public static final LIST<?> SIL = null;
    protected LinkedList<C> list = null;
    protected Iterator<C> iter = null;

    public LIST() {
        this(new LinkedList());
    }

    protected LIST(LinkedList<C> l) {
        this.list = l;
        this.iter = null;
    }

    public LIST(List<C> l) {
        this(new LinkedList<C>(l));
    }

    protected static <C> boolean isNull(LIST<C> L) {
        return L == null || L.list == null;
    }

    public static <C> boolean isEmpty(LIST<C> L) {
        if (LIST.isNull(L) || L.list.isEmpty()) {
            return true;
        }
        if (L.iter != null) {
            return !L.iter.hasNext();
        }
        return false;
    }

    public static <C> int LENGTH(LIST<C> L) {
        if (LIST.isNull(L)) {
            return 0;
        }
        return L.list.size();
    }

    public static <C> C FIRST(LIST<C> L) {
        if (LIST.isNull(L)) {
            return null;
        }
        if (L.iter != null) {
            if (L.iter.hasNext()) {
                return L.iter.next();
            }
            L.iter = null;
            return null;
        }
        return L.list.getFirst();
    }

    public static <C> LIST<C> RED(LIST<C> L) {
        if (LIST.isNull(L)) {
            return L;
        }
        LIST<C> LP = L;
        if (L.iter == null) {
            LP = new LIST<C>(L.list);
            LP.iter = LP.list.iterator();
            C c = LP.iter.next();
        }
        return LP;
    }

    public static <C> void SFIRST(LIST<C> L, C a) {
        if (!LIST.isNull(L)) {
            L.list.set(0, a);
        }
    }

    public static <C> void SRED(LIST<C> L, LIST<C> LP) {
        if (!LIST.isNull(L)) {
            L.list.subList(1, L.list.size()).clear();
            if (!LIST.isEmpty(LP)) {
                L.list.addAll(LP.list);
            }
        }
    }

    public static <C> LIST<C> COMP(C a, LIST<C> L) {
        LIST<C> LP = L;
        if (L == null) {
            LP = new LIST<C>();
        }
        LP.list.addFirst(a);
        return LP;
    }

    public String toString() {
        if (LIST.isNull(this)) {
            return "[]";
        }
        return this.list.toString();
    }

    public static <C> LIST<C> REDUCT(LIST<C> L, int i) {
        LIST LP = null;
        if (!LIST.isNull(L)) {
            LP = new LIST(L.list.subList(i, L.list.size()));
        }
        return LP;
    }

    public static <C> LIST<C> RED2(LIST<C> L) {
        LIST LP = null;
        if (!LIST.isNull(L)) {
            LP = new LIST(L.list.subList(2, L.list.size()));
        }
        return LP;
    }

    public static <C> LIST<C> RED3(LIST<C> L) {
        LIST LP = null;
        if (!LIST.isNull(L)) {
            LP = new LIST(L.list.subList(3, L.list.size()));
        }
        return LP;
    }

    public static <C> LIST<C> RED4(LIST<C> L) {
        LIST LP = null;
        if (!LIST.isNull(L)) {
            LP = new LIST(L.list.subList(42, L.list.size()));
        }
        return LP;
    }

    public static long CLOCK() {
        return System.currentTimeMillis();
    }

    public static <C> C LELT(LIST<C> L, int i) {
        C x = null;
        if (!LIST.isNull(L)) {
            x = L.list.get(i);
        }
        return x;
    }

    public static <C> C SECOND(LIST<C> L) {
        C x = null;
        if (!LIST.isNull(L)) {
            x = L.list.get(2);
        }
        return x;
    }

    public static <C> C THIRD(LIST<C> L) {
        C x = null;
        if (!LIST.isNull(L)) {
            x = L.list.get(3);
        }
        return x;
    }

    public static <C> C FOURTH(LIST<C> L) {
        C x = null;
        if (!LIST.isNull(L)) {
            x = L.list.get(4);
        }
        return x;
    }

    public static <C> LIST<C> CCONC(LIST<C> L1, LIST<C> L2) {
        if (LIST.isNull(L1)) {
            return L2;
        }
        if (LIST.isNull(L2)) {
            return L1;
        }
        LinkedList<C> list = new LinkedList<C>(L1.list);
        list.addAll(L2.list);
        return new LIST<C>(list);
    }

    public static <C> LIST<C> CINV(LIST<C> L) {
        if (LIST.isNull(L)) {
            return L;
        }
        LinkedList<C> list = new LinkedList<C>(L.list);
        Collections.reverse(list);
        return new LIST<C>(list);
    }

    public static <C> LIST<C> INV(LIST<C> L) {
        if (LIST.isNull(L)) {
            return L;
        }
        Collections.reverse(L.list);
        return L;
    }

    public static <C> LIST<C> COMP2(C a, C b, LIST<C> L) {
        LIST<C> LP = L;
        if (L == null) {
            LP = new LIST<C>();
        }
        LP.list.addFirst(b);
        LP.list.addFirst(a);
        return LP;
    }

    public static <C> LIST<C> COMP3(C a, C b, C c, LIST<C> L) {
        LIST<C> LP = L;
        if (L == null) {
            LP = new LIST<C>();
        }
        LP.list.addFirst(c);
        LP.list.addFirst(b);
        LP.list.addFirst(a);
        return LP;
    }

    public static <C> LIST<C> COMP3(C a, C b, C c, C d, LIST<C> L) {
        LIST<C> LP = L;
        if (L == null) {
            LP = new LIST<C>();
        }
        LP.list.addFirst(d);
        LP.list.addFirst(c);
        LP.list.addFirst(b);
        LP.list.addFirst(a);
        return LP;
    }

    public static <C> LIST<C> CONC(LIST<C> L1, LIST<C> L2) {
        if (LIST.isNull(L1)) {
            return L2;
        }
        if (LIST.isNull(L2)) {
            return L1;
        }
        L1.list.addAll(L2.list);
        return L1;
    }

    public static <C> boolean EQUAL(LIST<C> L1, LIST<C> L2) {
        if (LIST.isNull(L1)) {
            return LIST.isNull(L2);
        }
        if (LIST.isNull(L2)) {
            return LIST.isNull(L1);
        }
        return L1.list.equals(L2.list);
    }

    public static <C> int EXTENT(LIST<C> L) {
        if (LIST.isNull(L)) {
            return 0;
        }
        int n = 0;
        for (Object a : L.list) {
            if (a instanceof LIST) {
                LIST LP = null;
                try {
                    LP = (LIST)a;
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                if (LIST.isNull(LP)) {
                    ++n;
                    continue;
                }
                n += LIST.EXTENT(LP);
                continue;
            }
            ++n;
        }
        return n;
    }

    public static <C> LIST<C> LIST1(C a) {
        LIST<C> L = new LIST<C>();
        L.list.addFirst(a);
        return L;
    }

    public static <C> LIST<C> LIST10(C a1, C a2, C a3, C a4, C a5, C a6, C a7, C a8, C a9, C a10) {
        LIST<C> L = new LIST<C>();
        L.list.addFirst(a10);
        L.list.addFirst(a9);
        L.list.addFirst(a8);
        L.list.addFirst(a7);
        L.list.addFirst(a6);
        L.list.addFirst(a5);
        L.list.addFirst(a4);
        L.list.addFirst(a3);
        L.list.addFirst(a2);
        L.list.addFirst(a1);
        return L;
    }

    public static <C> LIST<C> LIST2(C a, C b) {
        LIST<C> L = new LIST<C>();
        L.list.addFirst(b);
        L.list.addFirst(a);
        return L;
    }

    public static <C> LIST<C> LIST3(C a, C b, C c) {
        LIST<C> L = new LIST<C>();
        L.list.addFirst(c);
        L.list.addFirst(b);
        L.list.addFirst(a);
        return L;
    }

    public static <C> LIST<C> LIST4(C a, C b, C c, C d) {
        LIST<C> L = new LIST<C>();
        L.list.addFirst(d);
        L.list.addFirst(c);
        L.list.addFirst(b);
        L.list.addFirst(a);
        return L;
    }

    public static <C> LIST<C> LIST5(C a, C b, C c, C d, C e) {
        LIST<C> L = new LIST<C>();
        L.list.addFirst(e);
        L.list.addFirst(d);
        L.list.addFirst(c);
        L.list.addFirst(b);
        L.list.addFirst(a);
        return L;
    }

    public static <C> int ORDER(LIST<C> L) {
        if (LIST.isNull(L)) {
            return 0;
        }
        int n = 0;
        for (Object a : L.list) {
            int o;
            if (!(a instanceof LIST)) continue;
            LIST LP = null;
            try {
                LP = (LIST)a;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (LIST.isNull(LP) || (o = LIST.ORDER(LP)) <= n) continue;
            n = o;
        }
        return n + 1;
    }
}

