/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.kern.StringUtil;
import edu.jas.structure.AlgebraFactory;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class GenMatrixRing<C extends RingElem<C>>
implements AlgebraFactory<GenMatrix<C>, C> {
    private static final Logger logger = Logger.getLogger(GenMatrixRing.class);
    public final RingFactory<C> coFac;
    public final int rows;
    public final int cols;
    public final int blocksize;
    public static final int DEFAULT_BSIZE = 10;
    public final GenMatrix<C> ZERO;
    public final GenMatrix<C> ONE;
    private static final Random random = new Random();
    public static final float DEFAULT_DENSITY = 0.5f;
    private final float density = 0.5f;

    public GenMatrixRing(RingFactory<C> b, int r, int c) {
        this(b, r, c, 10);
    }

    public GenMatrixRing(RingFactory<C> b, int r, int c, int s) {
        if (b == null) {
            throw new IllegalArgumentException("RingFactory is null");
        }
        if (r < 1) {
            throw new IllegalArgumentException("rows < 1 " + r);
        }
        if (c < 1) {
            throw new IllegalArgumentException("cols < 1 " + c);
        }
        this.coFac = b;
        this.rows = r;
        this.cols = c;
        this.blocksize = s;
        ArrayList z = new ArrayList(this.cols);
        for (int i = 0; i < this.cols; ++i) {
            z.add(this.coFac.getZERO());
        }
        ArrayList<ArrayList<Object>> m = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            m.add(new ArrayList(z));
        }
        this.ZERO = new GenMatrix(this, m);
        m = new ArrayList(this.rows);
        RingElem one = (RingElem)this.coFac.getONE();
        for (int i = 0; i < this.rows; ++i) {
            if (i >= this.cols) continue;
            ArrayList<RingElem> v = new ArrayList<RingElem>(z);
            v.set(i, one);
            m.add(v);
        }
        this.ONE = new GenMatrix(this, m);
        logger.info((Object)(this.rows + " x " + this.cols + " with blocksize " + this.blocksize + " matrix ring over " + this.coFac + "constructed"));
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.coFac.getClass().getSimpleName());
        s.append("[" + this.rows + "," + this.cols + "]");
        return s.toString();
    }

    @Override
    public String toScript() {
        StringBuffer s = new StringBuffer("Mat(");
        String f = null;
        try {
            f = ((RingElem)((Object)this.coFac)).toScriptFactory();
        }
        catch (Exception e) {
            f = this.coFac.toScript();
        }
        s.append(f + "," + this.rows + "," + this.cols + ")");
        return s.toString();
    }

    @Override
    public GenMatrix<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public GenMatrix<C> getONE() {
        return this.ONE;
    }

    @Override
    public List<GenMatrix<C>> generators() {
        List rgens = this.coFac.generators();
        ArrayList<GenMatrix<C>> gens = new ArrayList<GenMatrix<C>>(this.rows * this.cols * rgens.size());
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                for (RingElem el : rgens) {
                    GenMatrix<RingElem> g = this.ZERO.set(i, j, el);
                    gens.add(g);
                }
            }
        }
        return gens;
    }

    @Override
    public boolean isFinite() {
        return this.coFac.isFinite();
    }

    public boolean equals(Object other) {
        if (!(other instanceof GenMatrixRing)) {
            return false;
        }
        GenMatrixRing omod = (GenMatrixRing)other;
        if (this.rows != omod.rows) {
            return false;
        }
        if (this.cols != omod.cols) {
            return false;
        }
        return this.coFac.equals(omod.coFac);
    }

    public int hashCode() {
        int h = this.rows * 17 + this.cols;
        h = 37 * h + this.coFac.hashCode();
        return h;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public boolean isAssociative() {
        return this.rows == this.cols;
    }

    @Override
    public BigInteger characteristic() {
        return this.coFac.characteristic();
    }

    public GenMatrixRing<C> transpose() {
        if (this.rows == this.cols) {
            return this;
        }
        return new GenMatrixRing<C>(this.coFac, this.cols, this.rows, this.blocksize);
    }

    public GenMatrixRing<C> product(GenMatrixRing<C> other) {
        if (this.cols != other.rows) {
            throw new IllegalArgumentException("invalid dimensions in product");
        }
        if (!this.coFac.equals(other.coFac)) {
            throw new IllegalArgumentException("invalid coefficients in product");
        }
        if (this.rows == other.rows && this.cols == other.cols) {
            return this;
        }
        return new GenMatrixRing<C>(this.coFac, this.rows, other.cols, this.blocksize);
    }

    @Override
    public GenMatrix<C> fromInteger(long a) {
        RingElem c = (RingElem)this.coFac.fromInteger(a);
        return this.ONE.scalarMultiply(c);
    }

    @Override
    public GenMatrix<C> fromInteger(BigInteger a) {
        RingElem c = (RingElem)this.coFac.fromInteger(a);
        return this.ONE.scalarMultiply(c);
    }

    @Override
    public GenMatrix<C> fromList(List<List<C>> om) {
        if (om == null) {
            return this.ZERO;
        }
        if (om.size() > this.rows) {
            throw new IllegalArgumentException("size v > rows " + om + " > " + this.rows);
        }
        ArrayList m = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<Object> v;
            List<C> ov = om.get(i);
            if (ov == null) {
                v = this.ZERO.matrix.get(0);
            } else {
                if (ov.size() > this.cols) {
                    throw new IllegalArgumentException("size v > cols " + ov + " > " + this.cols);
                }
                v = new ArrayList(this.cols);
                v.addAll(ov);
                for (int j = v.size(); j < this.cols; ++j) {
                    v.add(this.coFac.getZERO());
                }
            }
            m.add(v);
        }
        return new GenMatrix(this, m);
    }

    @Override
    public GenMatrix<C> random(int k) {
        return this.random(k, 0.5f, random);
    }

    @Override
    public GenMatrix<C> random(int k, float q) {
        return this.random(k, q, random);
    }

    @Override
    public GenMatrix<C> random(int k, Random random) {
        return this.random(k, 0.5f, random);
    }

    public GenMatrix<C> random(int k, float q, Random random) {
        ArrayList m = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.cols);
            for (int j = 0; j < this.cols; ++j) {
                RingElem e = random.nextFloat() < q ? (RingElem)this.coFac.random(k) : (RingElem)this.coFac.getZERO();
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix(this, m);
    }

    public GenMatrix<C> randomUpper(int k, float q) {
        return this.randomUpper(k, q, random);
    }

    public GenMatrix<C> randomUpper(int k, float q, Random random) {
        ArrayList m = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.cols);
            for (int j = 0; j < this.cols; ++j) {
                RingElem e = (RingElem)this.coFac.getZERO();
                if (j >= i && random.nextFloat() < q) {
                    e = (RingElem)this.coFac.random(k);
                }
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix(this, m);
    }

    public GenMatrix<C> randomLower(int k, float q) {
        return this.randomLower(k, q, random);
    }

    public GenMatrix<C> randomLower(int k, float q, Random random) {
        ArrayList m = new ArrayList(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<RingElem> v = new ArrayList<RingElem>(this.cols);
            for (int j = 0; j < this.cols; ++j) {
                RingElem e = (RingElem)this.coFac.getZERO();
                if (j <= i && random.nextFloat() < q) {
                    e = (RingElem)this.coFac.random(k);
                }
                v.add(e);
            }
            m.add(v);
        }
        return new GenMatrix(this, m);
    }

    @Override
    public GenMatrix<C> copy(GenMatrix<C> c) {
        if (c == null) {
            return c;
        }
        return c.copy();
    }

    @Override
    public GenMatrix<C> parse(String s) {
        int i = s.indexOf("[");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        ArrayList mat = new ArrayList(this.rows);
        GenVectorModul<C> vmod = new GenVectorModul<C>(this.coFac, this.cols);
        do {
            String e;
            int j;
            if ((i = s.indexOf("]")) != (j = s.lastIndexOf("]"))) {
                if (i < 0) continue;
                e = s.substring(0, i);
                s = s.substring(i);
                Element vec = vmod.parse(e);
                ArrayList v = (ArrayList)((GenVector)vec).val;
                mat.add(v);
                i = s.indexOf(",");
                if (i < 0) continue;
                s = s.substring(i + 1);
                continue;
            }
            if (i < 0 || (e = s.substring(0, i)).trim().length() <= 0) break;
            throw new RuntimeException("Error e not empty " + e);
        } while (i >= 0);
        return new GenMatrix(this, mat);
    }

    @Override
    public GenMatrix<C> parse(Reader r) {
        String s = StringUtil.nextPairedString(r, '[', ']');
        return this.parse(s);
    }
}

