/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.RemoteExecutable;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import org.apache.log4j.Logger;

class Executor
extends Thread {
    private static final Logger logger = Logger.getLogger(Executor.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final SocketChannel channel;

    Executor(SocketChannel s) {
        this.channel = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RemoteExecutable re = null;
        boolean goon = true;
        logger.debug((Object)("executor started " + this));
        while (goon) {
            try {
                Object o = this.channel.receive();
                logger.info((Object)("receive: " + o + " from " + this.channel));
                if (this.isInterrupted()) {
                    goon = false;
                    continue;
                }
                if (this.debug) {
                    logger.debug((Object)("receive: " + o + " from " + this.channel));
                }
                if (o instanceof String) {
                    String d = (String)o;
                    if ("Stop".equals(d)) {
                        goon = false;
                        this.channel.send("Done");
                    } else {
                        logger.warn((Object)("invalid/unknown String: " + d + " from " + this.channel));
                        goon = false;
                        this.channel.send("Done");
                    }
                }
                if (!(o instanceof RemoteExecutable)) continue;
                re = (RemoteExecutable)o;
                if (this.debug) {
                    logger.info((Object)("running " + re));
                }
                try {
                    re.run();
                }
                catch (Exception e) {
                    logger.info((Object)("Exception on re.run()" + e));
                    e.printStackTrace();
                }
                finally {
                    logger.info((Object)("finally re.run() " + re));
                }
                if (this.debug) {
                    logger.info((Object)("finished " + re));
                }
                if (this.isInterrupted()) {
                    goon = false;
                    continue;
                }
                this.channel.send("Done");
                logger.info((Object)"finished send Done");
            }
            catch (IOException e) {
                goon = false;
                logger.info((Object)("IOException " + e));
                if (!this.debug) continue;
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                goon = false;
                logger.info((Object)("ClassNotFoundException " + e));
                e.printStackTrace();
            }
            finally {
                logger.info((Object)("finally " + this));
            }
        }
        logger.info((Object)("executor terminated " + this));
        this.channel.close();
    }
}

