/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.Broadcaster;
import edu.jas.util.ChannelFactory;
import edu.jas.util.Counter;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DistributedListServer
extends Thread {
    private static final Logger logger = Logger.getLogger(DistributedListServer.class);
    public static final int DEFAULT_PORT = 4810;
    protected final ChannelFactory cf;
    protected List<Broadcaster> servers;
    private boolean goon = true;
    private Thread mythread = null;
    private Counter listElem = new Counter(0);
    protected final SortedMap<Counter, Object> theList;

    public DistributedListServer() {
        this(4810);
    }

    public DistributedListServer(int port) {
        this(new ChannelFactory(port));
    }

    public DistributedListServer(ChannelFactory cf) {
        this.cf = cf;
        cf.init();
        this.servers = new ArrayList<Broadcaster>();
        this.theList = new TreeMap<Counter, Object>();
    }

    public static void main(String[] args) throws InterruptedException {
        int port = 4810;
        if (args.length < 1) {
            System.out.println("Usage: DistributedListServer <port>");
        } else {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        DistributedListServer dls = new DistributedListServer(port);
        dls.init();
        dls.join();
    }

    public void init() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel channel = null;
        Broadcaster s = null;
        this.mythread = Thread.currentThread();
        while (this.goon) {
            try {
                channel = this.cf.getChannel();
                logger.debug((Object)("dls channel = " + channel));
                if (this.mythread.isInterrupted()) {
                    this.goon = false;
                    continue;
                }
                s = new Broadcaster(channel, this.servers, this.listElem, this.theList);
                int ls = 0;
                Object object = this.servers;
                synchronized (object) {
                    this.servers.add(s);
                    ls = this.theList.size();
                    s.start();
                }
                if (ls <= 0) continue;
                logger.info((Object)("sending " + ls + " list elements"));
                object = this.theList;
                synchronized (object) {
                    Iterator<Map.Entry<Counter, Object>> it = this.theList.entrySet().iterator();
                    for (int i = 0; i < ls; ++i) {
                        Map.Entry<Counter, Object> e = it.next();
                        Counter n = e.getKey();
                        Object o = e.getValue();
                        try {
                            s.sendChannel(n, o);
                            continue;
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (InterruptedException end) {
                this.goon = false;
                Thread.currentThread().interrupt();
            }
        }
    }

    public void terminate() {
        this.goon = false;
        logger.debug((Object)"terminating ListServer");
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.servers != null) {
            for (Broadcaster br : this.servers) {
                br.closeChannel();
                try {
                    while (br.isAlive()) {
                        br.interrupt();
                        br.join(100L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.servers = null;
        }
        logger.debug((Object)"Broadcasters terminated");
        if (this.mythread == null) {
            return;
        }
        try {
            while (this.mythread.isAlive()) {
                this.mythread.interrupt();
                this.mythread.join(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.mythread = null;
        logger.debug((Object)"ListServer terminated");
    }

    public int size() {
        if (this.servers == null) {
            return -1;
        }
        return this.servers.size();
    }
}

