/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.Counter;
import edu.jas.util.Listener;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DistributedList {
    private static final Logger logger = Logger.getLogger(DistributedList.class);
    protected final SortedMap<Counter, Object> theList;
    protected final ChannelFactory cf;
    protected SocketChannel channel = null;
    protected Listener listener = null;

    public DistributedList(String host) {
        this(host, 4810);
    }

    public DistributedList(String host, int port) {
        this(new ChannelFactory(port + 1), host, port);
    }

    public DistributedList(ChannelFactory cf, String host, int port) {
        this.cf = cf;
        cf.init();
        try {
            this.channel = cf.getChannel(host, port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.debug((Object)("dl channel = " + this.channel));
        this.theList = new TreeMap<Counter, Object>();
    }

    public DistributedList(SocketChannel sc) {
        this.cf = null;
        this.channel = sc;
        this.theList = new TreeMap<Counter, Object>();
    }

    public void init() {
        this.listener = new Listener(this.channel, this.theList);
        this.listener.start();
    }

    public void terminate() {
        if (this.cf != null) {
            this.cf.terminate();
            logger.warn((Object)("terminating " + this.cf));
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.listener == null) {
            return;
        }
        logger.debug((Object)("terminate " + this.listener));
        this.listener.setDone();
        try {
            while (this.listener.isAlive()) {
                this.listener.interrupt();
                this.listener.join(100L);
            }
        }
        catch (InterruptedException u) {
            Thread.currentThread().interrupt();
        }
        this.listener = null;
    }

    public List<Object> getList() {
        return new ArrayList<Object>(this.theList.values());
    }

    public int size() {
        return this.theList.size();
    }

    public synchronized void add(Object o) {
        int sz1 = this.theList.size() + 1;
        try {
            this.channel.send(o);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            while (this.theList.size() < sz1) {
                this.wait(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    public synchronized void clear() {
        this.theList.clear();
    }

    public boolean isEmpty() {
        return this.theList.isEmpty();
    }

    public Iterator iterator() {
        return this.theList.values().iterator();
    }
}

