/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.DHTBroadcaster;
import edu.jas.util.DHTTransport;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DistHashTableServer<K>
extends Thread {
    private static final Logger logger = Logger.getLogger(DistHashTableServer.class);
    public static final int DEFAULT_PORT = 9009;
    protected final ChannelFactory cf;
    protected List<DHTBroadcaster<K>> servers;
    private boolean goon = true;
    private Thread mythread = null;
    protected final SortedMap<K, DHTTransport> theList;
    private long etime;
    private long dtime;
    private long ertime;
    private long drtime;

    public DistHashTableServer() {
        this(9009);
    }

    public DistHashTableServer(int port) {
        this(new ChannelFactory(port));
    }

    public DistHashTableServer(ChannelFactory cf) {
        this.cf = cf;
        cf.init();
        this.servers = new ArrayList<DHTBroadcaster<K>>();
        this.theList = new TreeMap<K, DHTTransport>();
        this.etime = DHTTransport.etime;
        this.dtime = DHTTransport.dtime;
        this.ertime = DHTTransport.ertime;
        this.drtime = DHTTransport.drtime;
    }

    public static void main(String[] args) throws InterruptedException {
        int port = 9009;
        if (args.length < 1) {
            System.out.println("Usage: DistHashTableServer <port>");
        } else {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        DistHashTableServer dhts = new DistHashTableServer(port);
        dhts.init();
        dhts.join();
    }

    public void init() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SocketChannel channel = null;
        DHTBroadcaster<K> s = null;
        this.mythread = Thread.currentThread();
        while (this.goon) {
            try {
                channel = this.cf.getChannel();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("dls channel = " + channel));
                }
                if (this.mythread.isInterrupted()) {
                    this.goon = false;
                    continue;
                }
                s = new DHTBroadcaster<K>(channel, this.servers, this.theList);
                int ls = 0;
                Object object = this.servers;
                synchronized (object) {
                    if (this.goon) {
                        this.servers.add(s);
                        ls = this.theList.size();
                        s.start();
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.info((Object)("server " + s + " started " + s.isAlive()));
                }
                if (ls <= 0) continue;
                object = this.theList;
                synchronized (object) {
                    Iterator<Map.Entry<K, DHTTransport>> it = this.theList.entrySet().iterator();
                    for (int i = 0; i < ls; ++i) {
                        Map.Entry<K, DHTTransport> e = it.next();
                        DHTTransport tc = e.getValue();
                        try {
                            s.sendChannel(tc);
                            continue;
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (InterruptedException end) {
                this.goon = false;
                Thread.currentThread().interrupt();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("DHTserver " + this + " terminated"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.goon = false;
        logger.debug((Object)"terminating");
        if (this.cf != null) {
            this.cf.terminate();
        }
        int svs = 0;
        ArrayList<DHTBroadcaster<K>> scopy = null;
        if (this.servers != null) {
            List<DHTBroadcaster<K>> list = this.servers;
            synchronized (list) {
                svs = this.servers.size();
                scopy = new ArrayList<DHTBroadcaster<K>>(this.servers);
                for (DHTBroadcaster dHTBroadcaster : scopy) {
                    dHTBroadcaster.goon = false;
                    dHTBroadcaster.closeChannel();
                    try {
                        int c = 0;
                        while (dHTBroadcaster.isAlive()) {
                            if (++c > 10) {
                                logger.warn((Object)("giving up on " + dHTBroadcaster));
                                break;
                            }
                            dHTBroadcaster.interrupt();
                            dHTBroadcaster.join(100L);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.info((Object)("server+ " + dHTBroadcaster + " terminated"));
                        }
                        this.servers.remove(dHTBroadcaster);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.servers.clear();
            }
            logger.info((Object)("" + svs + " broadcasters terminated " + scopy));
        }
        logger.debug((Object)"DHTBroadcasters terminated");
        long enc = DHTTransport.etime - this.etime;
        long l = DHTTransport.dtime - this.dtime;
        long encr = DHTTransport.ertime - this.ertime;
        long decr = DHTTransport.drtime - this.drtime;
        long drest = encr * l / (enc + 1L);
        logger.info((Object)("DHT time: encode = " + enc + ", decode = " + l + ", enc raw = " + encr + ", dec raw wait = " + decr + ", dec raw est = " + drest + ", sum est = " + (enc + l + encr + drest)));
        if (this.mythread == null) {
            return;
        }
        try {
            while (this.mythread.isAlive()) {
                this.mythread.interrupt();
                this.mythread.join(100L);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("server terminated " + this.mythread));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.mythread = null;
        logger.debug((Object)"terminated");
    }

    public int size() {
        if (this.servers == null) {
            return -1;
        }
        return this.servers.size();
    }

    @Override
    public String toString() {
        return "DHTServer(" + this.servers.size() + ", " + this.cf + ", " + super.toString() + ")";
    }
}

