/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.DHTListener;
import edu.jas.util.DHTTransport;
import edu.jas.util.DHTTransportClear;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DistHashTable<K, V>
extends AbstractMap<K, V> {
    private static final Logger logger = Logger.getLogger(DistHashTable.class);
    private static boolean debug = logger.isDebugEnabled();
    protected final SortedMap<K, V> theList;
    protected final ChannelFactory cf;
    protected SocketChannel channel = null;
    protected DHTListener<K, V> listener = null;

    public DistHashTable(String host) {
        this(host, 9009);
    }

    public DistHashTable(String host, int port) {
        this(new ChannelFactory(port + 1), host, port);
    }

    public DistHashTable(ChannelFactory cf, String host, int port) {
        this.cf = cf;
        cf.init();
        try {
            this.channel = cf.getChannel(host, port);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (debug) {
            logger.debug((Object)("dl channel = " + this.channel));
        }
        this.theList = new TreeMap();
        this.listener = new DHTListener<K, V>(this.channel, this.theList);
    }

    public DistHashTable(SocketChannel sc) {
        this.cf = null;
        this.channel = sc;
        this.theList = new TreeMap();
        this.listener = new DHTListener<K, V>(this.channel, this.theList);
    }

    @Override
    public int hashCode() {
        return this.theList.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.theList.equals(o);
    }

    @Override
    public boolean containsKey(Object o) {
        return this.theList.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.theList.containsValue(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return new ArrayList<V>(this.theList.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.entrySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> getValueList() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return new ArrayList<V>(this.theList.values());
        }
    }

    public SortedMap<K, V> getList() {
        return this.theList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<K> iterator() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.keySet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<V> valueIterator() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.values().iterator();
        }
    }

    public void putWait(K key, V value) {
        this.put(key, value);
        while (!value.equals(this.getWait(key))) {
        }
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException("null keys or values not allowed");
        }
        try {
            DHTTransport<K, V> tc = DHTTransport.create(key, value);
            this.channel.send(tc);
        }
        catch (IOException e) {
            logger.info((Object)("send, exception " + e));
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.info((Object)("send, exception " + e));
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getWait(K key) {
        V value = null;
        try {
            SortedMap<K, V> sortedMap = this.theList;
            synchronized (sortedMap) {
                value = this.get(key);
                while (value == null) {
                    this.theList.wait(100L);
                    value = this.theList.get(key);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            return this.theList.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            this.theList.clear();
        }
        try {
            DHTTransportClear tc = new DHTTransportClear();
            this.channel.send(tc);
        }
        catch (IOException e) {
            logger.info((Object)("send, exception " + e));
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.info((Object)("send, exception " + e));
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.listener == null) {
            return;
        }
        if (this.listener.isDone()) {
            return;
        }
        if (debug) {
            logger.debug((Object)("initialize " + this.listener));
        }
        SortedMap<K, V> sortedMap = this.theList;
        synchronized (sortedMap) {
            this.listener.start();
        }
    }

    public void terminate() {
        if (this.cf != null) {
            this.cf.terminate();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.listener == null) {
            return;
        }
        if (debug) {
            logger.debug((Object)("terminate " + this.listener));
        }
        this.listener.setDone();
        try {
            while (this.listener.isAlive()) {
                this.listener.interrupt();
                this.listener.join(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.listener = null;
    }
}

