/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DHTTransport;
import edu.jas.util.DHTTransportClear;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

class DHTBroadcaster<K>
extends Thread {
    private static final Logger logger = Logger.getLogger(DHTBroadcaster.class);
    private final SocketChannel channel;
    private final List<DHTBroadcaster<K>> bcaster;
    private final SortedMap<K, DHTTransport> theList;
    volatile boolean goon = true;

    public DHTBroadcaster(SocketChannel s, List<DHTBroadcaster<K>> bc, SortedMap<K, DHTTransport> sm) {
        this.channel = s;
        this.bcaster = bc;
        this.theList = sm;
    }

    public void closeChannel() {
        this.channel.close();
    }

    public void sendChannel(DHTTransport tc) throws IOException {
        if (this.goon) {
            this.channel.send(tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(DHTTransport o) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("broadcast = " + o));
        }
        DHTTransport tc = null;
        if (o == null) {
            return;
        }
        tc = o;
        Object key = null;
        SortedMap<K, DHTTransport> sortedMap = this.theList;
        synchronized (sortedMap) {
            try {
                if (!(o instanceof DHTTransportClear)) {
                    key = tc.key();
                    this.theList.put(key, tc);
                }
            }
            catch (IOException e) {
                logger.warn((Object)("IO exception: tc.key() not ok " + tc));
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("CNF exception: tc.key() not ok " + tc));
                e.printStackTrace();
            }
            catch (Exception e) {
                logger.warn((Object)("exception: tc.key() not ok " + tc));
                e.printStackTrace();
            }
        }
        logger.info((Object)("sending key=" + key + " to " + this.bcaster.size() + " nodes"));
        ArrayList<DHTBroadcaster<K>> bccopy = null;
        List<DHTBroadcaster<K>> e = this.bcaster;
        synchronized (e) {
            bccopy = new ArrayList<DHTBroadcaster<K>>(this.bcaster);
        }
        for (DHTBroadcaster dHTBroadcaster : bccopy) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("bcasting to " + dHTBroadcaster));
                }
                dHTBroadcaster.sendChannel(tc);
            }
            catch (IOException e2) {
                logger.info((Object)("bcaster, IOexception " + e2));
                List<DHTBroadcaster<K>> list = this.bcaster;
                synchronized (list) {
                    this.bcaster.remove(dHTBroadcaster);
                }
                try {
                    dHTBroadcaster.goon = false;
                    dHTBroadcaster.closeChannel();
                    while (dHTBroadcaster.isAlive()) {
                        dHTBroadcaster.interrupt();
                        dHTBroadcaster.join(100L);
                    }
                }
                catch (InterruptedException w) {
                    Thread.currentThread().interrupt();
                }
                logger.info((Object)("bcaster.remove() " + dHTBroadcaster));
            }
            catch (Exception e3) {
                logger.info((Object)("bcaster, exception " + e3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.goon = true;
        while (this.goon) {
            try {
                logger.debug((Object)"trying to receive");
                Object o = this.channel.receive();
                if (this.isInterrupted()) {
                    this.goon = false;
                    break;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("received = " + o));
                }
                if (!(o instanceof DHTTransport)) {
                    logger.warn((Object)("wrong object type: " + o));
                    this.goon = false;
                    break;
                }
                if (o instanceof DHTTransportClear) {
                    logger.info((Object)"receive, clear");
                    SortedMap<K, DHTTransport> sortedMap = this.theList;
                    synchronized (sortedMap) {
                        this.theList.clear();
                        this.theList.notifyAll();
                    }
                }
                DHTTransport tc = (DHTTransport)o;
                this.broadcast(tc);
                if (!this.isInterrupted()) continue;
                this.goon = false;
            }
            catch (IOException e) {
                this.goon = false;
                logger.info((Object)("receive, IO exception " + e));
            }
            catch (ClassNotFoundException e) {
                this.goon = false;
                logger.info((Object)("receive, CNF exception " + e));
                e.printStackTrace();
            }
            catch (Exception e) {
                this.goon = false;
                logger.info((Object)("receive, exception " + e));
                e.printStackTrace();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("terminated+ " + this));
        }
        List<DHTBroadcaster<K>> list = this.bcaster;
        synchronized (list) {
            this.bcaster.remove(this);
        }
        this.channel.close();
    }

    @Override
    public String toString() {
        return "DHTBroadcaster(" + this.channel + "," + this.bcaster.size() + ")";
    }
}

