/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.Squarefree;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class SquarefreeAbstract<C extends GcdRingElem<C>>
implements Squarefree<C> {
    protected final GreatestCommonDivisorAbstract<C> engine;

    public SquarefreeAbstract(GreatestCommonDivisorAbstract<C> engine) {
        this.engine = engine;
    }

    public abstract GenPolynomial<C> baseSquarefreePart(GenPolynomial<C> var1);

    public abstract SortedMap<GenPolynomial<C>, Long> baseSquarefreeFactors(GenPolynomial<C> var1);

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateSquarefreePart(GenPolynomial<GenPolynomial<C>> var1);

    public abstract SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveUnivariateSquarefreeFactors(GenPolynomial<GenPolynomial<C>> var1);

    @Override
    public abstract GenPolynomial<C> squarefreePart(GenPolynomial<C> var1);

    @Override
    public boolean isSquarefree(GenPolynomial<C> P) {
        GenPolynomial<C> S = this.squarefreePart((C)P);
        GenPolynomial<C> Ps = P;
        Ps = P.ring.coFac.isField() ? Ps.monic() : this.engine.basePrimitivePart(Ps);
        boolean f = Ps.equals(S);
        return f;
    }

    @Override
    public boolean isSquarefree(List<GenPolynomial<C>> L) {
        if (L == null || L.isEmpty()) {
            return true;
        }
        for (GenPolynomial<C> P : L) {
            if (this.isSquarefree(P)) continue;
            return false;
        }
        return true;
    }

    public boolean isRecursiveSquarefree(GenPolynomial<GenPolynomial<C>> P) {
        GenPolynomial<GenPolynomial<C>> S = this.recursiveUnivariateSquarefreePart(P);
        boolean f = P.equals(S);
        if (!f) {
            System.out.println("\nisSquarefree: " + f);
            System.out.println("S = " + S);
            System.out.println("P = " + P);
        }
        return f;
    }

    @Override
    public abstract SortedMap<GenPolynomial<C>, Long> squarefreeFactors(GenPolynomial<C> var1);

    @Override
    public List<GenPolynomial<C>> coPrimeSquarefree(List<GenPolynomial<C>> A) {
        if (A == null || A.isEmpty()) {
            return A;
        }
        ArrayList S = new ArrayList();
        for (GenPolynomial<C> g : A) {
            SortedMap<GenPolynomial<C>, Long> sm = this.squarefreeFactors((C)g);
            S.addAll(sm.keySet());
        }
        List<GenPolynomial<C>> B = this.engine.coPrime(S);
        return B;
    }

    @Override
    public List<GenPolynomial<C>> coPrimeSquarefree(GenPolynomial<C> a, List<GenPolynomial<C>> P) {
        if (a == null || a.isZERO() || a.isConstant()) {
            return P;
        }
        SortedMap<GenPolynomial<C>, Long> sm = this.squarefreeFactors((C)a);
        List<GenPolynomial<C>> B = P;
        for (GenPolynomial<C> f : sm.keySet()) {
            B = this.engine.coPrime(f, B);
        }
        return B;
    }

    @Override
    public boolean isCoPrimeSquarefree(List<GenPolynomial<C>> B) {
        if (B == null || B.isEmpty()) {
            return true;
        }
        if (!this.engine.isCoPrime(B)) {
            return false;
        }
        return this.isSquarefree(B);
    }

    public SortedMap<GenPolynomial<C>, Long> normalizeFactorization(SortedMap<GenPolynomial<C>, Long> F) {
        if (F == null || F.size() <= 1) {
            return F;
        }
        ArrayList<GenPolynomial<C>> Fp = new ArrayList<GenPolynomial<C>>(F.keySet());
        AbelianGroupElem f0 = (GenPolynomial)Fp.get(0);
        if (f0.ring.characteristic().signum() != 0) {
            return F;
        }
        long e0 = (Long)F.get(f0);
        TreeMap<GenPolynomial<C>, Long> Sp = new TreeMap<GenPolynomial<C>, Long>();
        for (int i = 1; i < Fp.size(); ++i) {
            AbelianGroupElem fi = (GenPolynomial)Fp.get(i);
            long ei = (Long)F.get(fi);
            if (fi.signum() < 0) {
                fi = fi.negate();
                if (ei % 2L != 0L) {
                    f0 = f0.negate();
                }
            }
            Sp.put((GenPolynomial<C>)fi, ei);
        }
        if (!f0.isONE()) {
            Sp.put((GenPolynomial<C>)f0, e0);
        }
        return Sp;
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> P, List<GenPolynomial<C>> F) {
        boolean f;
        if (P == null || F == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> t = P.ring.getONE();
        for (GenPolynomial<C> f2 : F) {
            t = t.multiply((GenPolynomial<GenPolynomial<C>>)f2);
        }
        boolean bl = f = P.equals(t) || P.equals(t.negate());
        if (!f) {
            System.out.println("\nfactorization(list): " + f);
            System.out.println("F = " + F);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
        }
        return f;
    }

    public long factorCount(SortedMap<GenPolynomial<C>, Long> F) {
        if (F == null || F.isEmpty()) {
            return 0L;
        }
        long f = 0L;
        for (Long e : F.values()) {
            f += e.longValue();
        }
        return f;
    }

    @Override
    public boolean isFactorization(GenPolynomial<C> P, SortedMap<GenPolynomial<C>, Long> F) {
        boolean f;
        if (P == null || F == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (P.isZERO() && F.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial<C>> t = P.ring.getONE();
        for (Map.Entry<GenPolynomial<C>, Long> me : F.entrySet()) {
            GenPolynomial<C> f2 = me.getKey();
            Long E = me.getValue();
            long e = E;
            GenPolynomial<C> g = Power.positivePower(f2, e);
            t = t.multiply(g);
        }
        boolean bl = f = P.equals(t) || P.equals(t.negate());
        if (!f) {
            boolean bl2 = f = (P = P.monic()).equals(t = t.monic()) || P.equals(t.negate());
            if (f) {
                return f;
            }
            System.out.println("\nfactorization(map): " + f);
            System.out.println("F = " + F);
            System.out.println("P = " + P);
            System.out.println("t = " + t);
        }
        return f;
    }

    public boolean isRecursiveFactorization(GenPolynomial<GenPolynomial<C>> P, SortedMap<GenPolynomial<GenPolynomial<C>>, Long> F) {
        boolean f;
        if (P == null || F == null) {
            throw new IllegalArgumentException("P and F may not be null");
        }
        if (P.isZERO() && F.size() == 0) {
            return true;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> t = P.ring.getONE();
        for (Map.Entry<GenPolynomial<GenPolynomial<C>>, Long> me : F.entrySet()) {
            GenPolynomial<GenPolynomial<C>> f2 = me.getKey();
            Long E = me.getValue();
            long e = E;
            GenPolynomial<GenPolynomial<C>> g = Power.positivePower(f2, e);
            t = t.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)g);
        }
        boolean bl = f = P.equals(t) || P.equals(t.negate());
        if (!f) {
            GenPolynomialRing cf = (GenPolynomialRing)P.ring.coFac;
            GreatestCommonDivisorAbstract<C> engine = GCDFactory.getProxy(cf.coFac);
            GenPolynomial Pp = engine.recursivePrimitivePart(P);
            Pp = PolyUtil.monic(Pp);
            GenPolynomial tp = engine.recursivePrimitivePart(t);
            boolean bl2 = f = Pp.equals(tp = PolyUtil.monic(tp)) || Pp.equals(tp.negate());
            if (f) {
                return f;
            }
            System.out.println("\nfactorization(map): " + f);
            System.out.println("F  = " + F);
            System.out.println("P  = " + P);
            System.out.println("t  = " + t);
            System.out.println("Pp = " + Pp);
            System.out.println("tp = " + tp);
        }
        return f;
    }

    public GenPolynomial<GenPolynomial<C>> recursiveSquarefreePart(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        if (P.ring.nvar <= 1) {
            return this.recursiveUnivariateSquarefreePart(P);
        }
        GenPolynomialRing rfac = P.ring;
        RingFactory rrfac = rfac.coFac;
        GenPolynomialRing cfac = (GenPolynomialRing)rrfac;
        GenPolynomialRing dfac = cfac.extend(rfac.nvar);
        GenPolynomial Pd = PolyUtil.distribute(dfac, P);
        GenPolynomial Dd = this.squarefreePart((C)Pd);
        GenPolynomial C = PolyUtil.recursive(rfac, Dd);
        return C;
    }

    public SortedMap<GenPolynomial<GenPolynomial<C>>, Long> recursiveSquarefreeFactors(GenPolynomial<GenPolynomial<C>> P) {
        TreeMap<GenPolynomial<GenPolynomial<C>>, Long> factors = new TreeMap<GenPolynomial<GenPolynomial<C>>, Long>();
        if (P == null || P.isZERO()) {
            return factors;
        }
        if (P.ring.nvar <= 1) {
            return this.recursiveUnivariateSquarefreeFactors(P);
        }
        GenPolynomialRing rfac = P.ring;
        RingFactory rrfac = rfac.coFac;
        GenPolynomialRing cfac = (GenPolynomialRing)rrfac;
        GenPolynomialRing dfac = cfac.extend(rfac.nvar);
        GenPolynomial Pd = PolyUtil.distribute(dfac, P);
        SortedMap dfacs = this.squarefreeFactors((C)Pd);
        for (Map.Entry Dm : dfacs.entrySet()) {
            GenPolynomial Dd = Dm.getKey();
            Long e = Dm.getValue();
            GenPolynomial C = PolyUtil.recursive(rfac, Dd);
            factors.put(C, e);
        }
        return factors;
    }

    public List<List<GenPolynomial<C>>> basePartialFraction(GenPolynomial<C> A, SortedMap<GenPolynomial<C>, Long> D) {
        if (D == null || A == null) {
            throw new IllegalArgumentException("null A or D not allowed");
        }
        ArrayList<List<GenPolynomial<C>>> pf = new ArrayList<List<GenPolynomial<C>>>(D.size() + 1);
        if (D.size() == 0) {
            return pf;
        }
        if (A.isZERO()) {
            for (Map.Entry<GenPolynomial<C>, Long> me : D.entrySet()) {
                long e = me.getValue();
                int e1 = (int)e + 1;
                ArrayList<GenPolynomial<C>> fi = new ArrayList<GenPolynomial<C>>(e1);
                for (int i = 0; i < e1; ++i) {
                    fi.add(A);
                }
                pf.add(fi);
            }
            ArrayList<GenPolynomial<C>> fi = new ArrayList<GenPolynomial<C>>(1);
            fi.add(A);
            pf.add(0, fi);
            return pf;
        }
        ArrayList Dp = new ArrayList(D.size());
        for (Map.Entry<GenPolynomial<C>, Long> me : D.entrySet()) {
            GenPolynomial<C> d = me.getKey();
            long e = me.getValue();
            GenPolynomial<C> f = Power.positivePower(d, e);
            Dp.add(f);
        }
        List<GenPolynomial<C>> F = this.engine.basePartialFraction(A, Dp);
        GenPolynomial<C> A0 = F.remove(0);
        ArrayList<GenPolynomial<C>> fi = new ArrayList<GenPolynomial<C>>(1);
        fi.add(A0);
        pf.add(fi);
        int i = 0;
        for (Map.Entry<GenPolynomial<C>, Long> me : D.entrySet()) {
            GenPolynomial<C> d = me.getKey();
            long e = me.getValue();
            int ei = (int)e;
            GenPolynomial<C> gi = F.get(i);
            List<GenPolynomial<C>> Fi = this.engine.basePartialFraction(gi, d, ei);
            pf.add(Fi);
            ++i;
        }
        return pf;
    }

    public boolean isBasePartialFraction(GenPolynomial<C> A, SortedMap<GenPolynomial<C>, Long> D, List<List<GenPolynomial<C>>> F) {
        if (D == null || A == null || F == null) {
            throw new IllegalArgumentException("null A, D or F not allowed");
        }
        if (D.isEmpty() && F.isEmpty()) {
            return true;
        }
        if (D.isEmpty() || F.isEmpty()) {
            return false;
        }
        ArrayList Dp = new ArrayList(D.size());
        for (Map.Entry<GenPolynomial<C>, Long> me : D.entrySet()) {
            GenPolynomial<C> d = me.getKey();
            long e = me.getValue();
            GenPolynomial<C> f = Power.positivePower(d, e);
            Dp.add(f);
        }
        List<GenPolynomial<C>> fi = F.get(0);
        if (fi.size() != 1) {
            System.out.println("size(fi) != 1 " + fi);
            return false;
        }
        GenPolynomial<C> A0 = fi.get(0);
        ArrayList Qp = new ArrayList(D.size() + 1);
        Qp.add(A0);
        int i = 0;
        for (Map.Entry<GenPolynomial<C>, Long> me : D.entrySet()) {
            GenPolynomial<C> d = me.getKey();
            long e = me.getValue();
            int ei = (int)e;
            List<GenPolynomial<C>> Fi = F.get(i + 1);
            GenPolynomial<C> qi = this.engine.basePartialFractionValue(d, ei, Fi);
            Qp.add(qi);
            ++i;
        }
        boolean t = this.engine.isBasePartialFraction(A, Dp, Qp);
        if (!t) {
            System.out.println("not final isPartFrac " + Qp);
        }
        return t;
    }

    public C squarefreePart(C P) {
        if (P == null) {
            return null;
        }
        GcdRingElem s = null;
        SortedMap<C, Long> factors = this.squarefreeFactors(P);
        System.out.println("sqfPart,factors = " + factors);
        for (GcdRingElem sp : factors.keySet()) {
            if (s == null) {
                s = sp;
                continue;
            }
            s = s.multiply(sp);
        }
        return (C)s;
    }

    public abstract SortedMap<C, Long> squarefreeFactors(C var1);
}

