/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.Factors;
import java.io.Serializable;
import java.util.List;

public class FactorsList<C extends GcdRingElem<C>>
implements Serializable {
    public final GenPolynomial<C> poly;
    public final List<GenPolynomial<C>> factors;
    public final List<Factors<C>> afactors;

    public FactorsList(GenPolynomial<C> p, List<GenPolynomial<C>> list) {
        this(p, list, null);
    }

    public FactorsList(GenPolynomial<C> p, List<GenPolynomial<C>> list, List<Factors<C>> alist) {
        this.poly = p;
        this.factors = list;
        this.afactors = alist;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (GenPolynomial<C> genPolynomial : this.factors) {
            if (first) {
                first = false;
            } else {
                sb.append(",\n ");
            }
            sb.append(genPolynomial.toString());
        }
        if (this.afactors == null) {
            return sb.toString();
        }
        for (Factors factors : this.afactors) {
            if (first) {
                first = false;
            } else {
                sb.append(",\n ");
            }
            sb.append(factors.toString());
        }
        return sb.toString();
    }

    public String toScript() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.poly.toScript());
        sb.append(" =\n");
        boolean first = true;
        for (GenPolynomial<C> genPolynomial : this.factors) {
            if (first) {
                first = false;
            } else {
                sb.append("\n * ");
            }
            sb.append(genPolynomial.toScript());
        }
        if (this.afactors == null) {
            return sb.toString();
        }
        for (Factors factors : this.afactors) {
            if (first) {
                first = false;
            } else {
                sb.append("\n * ");
            }
            sb.append(factors.toScript());
        }
        return sb.toString();
    }

    public AlgebraicNumberRing<C> findExtensionField() {
        if (this.afactors == null) {
            return null;
        }
        AlgebraicNumberRing<C> ar = null;
        int depth = 0;
        for (Factors<C> f : this.afactors) {
            int d;
            AlgebraicNumberRing<C> aring = f.findExtensionField();
            if (aring == null || (d = aring.depth()) <= depth) continue;
            depth = d;
            ar = aring;
        }
        return ar;
    }
}

