/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorAlgebraic;
import edu.jas.ufd.FactorComplex;
import edu.jas.ufd.FactorInteger;
import edu.jas.ufd.FactorModular;
import edu.jas.ufd.FactorQuotient;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import org.apache.log4j.Logger;

public class FactorFactory {
    private static final Logger logger = Logger.getLogger(FactorFactory.class);

    protected FactorFactory() {
    }

    public static FactorAbstract<ModInteger> getImplementation(ModIntegerRing fac) {
        return new FactorModular<ModInteger>(fac);
    }

    public static FactorAbstract<ModLong> getImplementation(ModLongRing fac) {
        return new FactorModular<ModLong>(fac);
    }

    public static FactorAbstract<BigInteger> getImplementation(BigInteger fac) {
        return new FactorInteger();
    }

    public static FactorAbstract<BigRational> getImplementation(BigRational fac) {
        return new FactorRational();
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<AlgebraicNumber<C>> getImplementation(AlgebraicNumberRing<C> fac) {
        return new FactorAlgebraic<C>(fac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Complex<C>> getImplementation(ComplexRing<C> fac) {
        return new FactorComplex<C>(fac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<Quotient<C>> getImplementation(QuotientRing<C> fac) {
        return new FactorQuotient<C>(fac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(GenPolynomialRing<C> fac) {
        return FactorFactory.getImplementation(fac.coFac);
    }

    public static <C extends GcdRingElem<C>> FactorAbstract<C> getImplementation(RingFactory<C> fac) {
        logger.info((Object)("factor factory = " + fac.getClass().getName()));
        FactorAbstract ufd = null;
        AlgebraicNumberRing afac = null;
        ComplexRing cfac = null;
        QuotientRing qfac = null;
        GenPolynomialRing pfac = null;
        RingFactory<C> ofac = fac;
        if (ofac instanceof BigInteger) {
            ufd = new FactorInteger();
        } else if (ofac instanceof BigRational) {
            ufd = new FactorRational();
        } else if (ofac instanceof ModIntegerRing) {
            ufd = new FactorModular<C>(fac);
        } else if (ofac instanceof ModLongRing) {
            ufd = new FactorModular<C>(fac);
        } else if (ofac instanceof ComplexRing) {
            cfac = (ComplexRing)ofac;
            ufd = new FactorComplex(cfac);
        } else if (ofac instanceof AlgebraicNumberRing) {
            afac = (AlgebraicNumberRing)ofac;
            ufd = new FactorAlgebraic(afac);
        } else if (ofac instanceof QuotientRing) {
            qfac = (QuotientRing)ofac;
            ufd = new FactorQuotient(qfac);
        } else if (ofac instanceof GenPolynomialRing) {
            pfac = (GenPolynomialRing)ofac;
            ufd = FactorFactory.getImplementation(pfac.coFac);
        } else {
            throw new IllegalArgumentException("no factorization implementation for " + fac.getClass().getName());
        }
        return ufd;
    }
}

