/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.structure.AlgebraElem;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.PartialFraction;
import edu.jas.ufd.QuotientRing;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import java.util.ArrayList;
import java.util.SortedMap;
import org.apache.log4j.BasicConfigurator;

public class Examples {
    public static void main(String[] args) {
        Examples.example1();
        Examples.example2();
        BasicConfigurator.configure();
        Examples.example10();
        ComputerThreads.terminate();
    }

    public static void example1() {
        System.out.println("\n\n example 1");
        BigInteger cfac = new BigInteger();
        System.out.println("cfac = " + cfac);
        String[] vc = new String[]{"a", "b"};
        GenPolynomialRing<BigInteger> fac = new GenPolynomialRing<BigInteger>(cfac, vc);
        System.out.println(" fac = " + fac.toScript());
        QuotientRing<BigInteger> efac = new QuotientRing<BigInteger>(fac);
        System.out.println("efac = " + efac.toScript());
        String[] v = new String[]{"x", "y", "z"};
        GenPolynomialRing<BigInteger> qfac = new GenPolynomialRing<BigInteger>(efac, 3, v);
        System.out.println("qfac = " + qfac.toScript());
        GenMatrixRing<BigInteger> mfac = new GenMatrixRing<BigInteger>(qfac, 3, 3);
        System.out.println("mfac = " + mfac.toScript());
        GenPolynomial<BigInteger> p = qfac.random(3, 4, 2, 0.3f);
        System.out.println("\np = " + p);
        AlgebraElem m = mfac.random(3, 0.4f);
        System.out.println("\nm = " + ((GenMatrix)m).toScript());
    }

    public static void example2() {
        System.out.println("\n\n example 2");
        BigInteger fac = new BigInteger();
        String[] var = new String[]{"a", "b", "c", "d"};
        int numvars = var.length;
        GenPolynomialRing<BigInteger> ring = new GenPolynomialRing<BigInteger>(fac, var);
        ArrayList<GenPolynomial<BigInteger>> vars = new ArrayList<GenPolynomial<BigInteger>>();
        for (int i = 0; i < numvars; ++i) {
            vars.add(ring.univariate(i));
        }
        System.out.println("vars = " + vars);
        GenPolynomial<GenPolynomial<GenPolynomial>> tmp = ((GenPolynomial)vars.get(0)).multiply((GenPolynomial)vars.get(1)).sum((GenPolynomial)((GenPolynomial)vars.get(0)).multiply((GenPolynomial)vars.get(2))).sum(((GenPolynomial)vars.get(3)).multiply((GenPolynomial)vars.get(1))).sum(((GenPolynomial)vars.get(3)).multiply((GenPolynomial)vars.get(2)));
        System.out.println("tmp = " + tmp);
        FactorAbstract<BigInteger> engine = FactorFactory.getImplementation(fac);
        SortedMap<GenPolynomial<GenPolynomial<GenPolynomial>>, Long> factors = engine.factors(tmp);
        System.out.println("factors = " + factors);
    }

    public static void example6() {
        System.out.println("\n\nexample 6");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("x^7 + x + 1");
        GenPolynomial N = PolyUtil.baseDeriviative(D);
        FactorRational engine = new FactorRational();
        PartialFraction F = engine.baseAlgebraicPartialFraction(N, D);
        System.out.println("\nintegral " + F);
    }

    public static void example9() {
        System.out.println("\n\nexample 9");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("( x^5 + x - 7 )");
        MonoidElem N = pfac.getONE();
        FactorRational engine = new FactorRational();
        PartialFraction F = engine.baseAlgebraicPartialFraction(N, D);
        System.out.println("\nintegral " + F);
    }

    public static void example10() {
        System.out.println("\n\nexample 10");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] var_w2 = new String[]{"w2"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, var_w2);
        System.out.println("pfac   = " + pfac.toScript());
        Element w2 = pfac.parse(" w2^2 - 2 ");
        System.out.println("w2     = " + w2);
        AlgebraicNumberRing a2fac = new AlgebraicNumberRing(w2, true);
        System.out.println("a2fac  = " + a2fac.toScript());
        String[] var_x = new String[]{"x"};
        GenPolynomialRing apfac = new GenPolynomialRing(a2fac, 1, to, var_x);
        System.out.println("apfac  = " + apfac.toScript());
        QuotientRing qfac = new QuotientRing(apfac);
        System.out.println("qfac   = " + qfac.toScript());
        String[] var_wx = new String[]{"wx"};
        GenPolynomialRing pqfac = new GenPolynomialRing(qfac, 1, to, var_wx);
        System.out.println("pqfac  = " + pqfac.toScript());
        Element wx = pqfac.parse(" wx^2 - { x } ");
        System.out.println("wx     = " + wx);
        AlgebraicNumberRing axfac = new AlgebraicNumberRing(wx, true);
        System.out.println("axfac  = " + axfac.toScript());
        String[] var_y = new String[]{"y"};
        GenPolynomialRing apqfac = new GenPolynomialRing(axfac, 1, to, var_y);
        System.out.println("apqfac = " + apqfac.toScript());
        Element f = apqfac.parse(" ( y^2 - { { x } } ) * ( y^2 - 2 )^2 ");
        System.out.println("f      = " + f);
        FactorAbstract engine = FactorFactory.getImplementation(axfac);
        System.out.println("engine = " + engine);
        SortedMap F = engine.factors(f);
        System.out.println("factors(f) = " + F);
    }
}

