/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.InvalidBoundaryException;
import edu.jas.root.Rectangle;
import edu.jas.structure.GcdRingElem;

public class ComplexAlgebraicNumber<C extends GcdRingElem<C> & Rational>
implements GcdRingElem<ComplexAlgebraicNumber<C>> {
    public final AlgebraicNumber<Complex<C>> number;
    public final ComplexAlgebraicRing<C> ring;

    public ComplexAlgebraicNumber(ComplexAlgebraicRing<C> r, GenPolynomial<Complex<C>> a) {
        this.number = new AlgebraicNumber<Complex<Complex<C>>>(r.algebraic, a);
        this.ring = r;
    }

    public ComplexAlgebraicNumber(ComplexAlgebraicRing<C> r, AlgebraicNumber<Complex<C>> a) {
        this.number = a;
        this.ring = r;
    }

    public ComplexAlgebraicNumber(ComplexAlgebraicRing<C> r) {
        this(r, (AlgebraicNumber<Complex<C>>)r.algebraic.getZERO());
    }

    @Override
    public ComplexAlgebraicRing<C> factory() {
        return this.ring;
    }

    @Override
    public ComplexAlgebraicNumber<C> copy() {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number);
    }

    @Override
    public boolean isZERO() {
        return this.number.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.number.isONE();
    }

    @Override
    public boolean isUnit() {
        return this.number.isUnit();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return "{ " + this.number.toString() + " }";
        }
        return "Complex" + this.number.toString();
    }

    @Override
    public String toScript() {
        return this.number.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((ComplexAlgebraicRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(ComplexAlgebraicNumber<C> b) {
        int s = 0;
        if (this.number.ring != b.number.ring) {
            s = this.number.ring.modul.compareTo(b.number.ring.modul);
            System.out.println("s_mod = " + s);
        }
        if (s != 0) {
            return s;
        }
        s = this.number.compareTo(b.number);
        return s;
    }

    @Override
    public int compareTo(AlgebraicNumber<Complex<C>> b) {
        int s = this.number.compareTo(b);
        return s;
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof ComplexAlgebraicNumber)) {
            return false;
        }
        ComplexAlgebraicNumber a = null;
        try {
            a = (ComplexAlgebraicNumber)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.number.equals(a.number);
    }

    @Override
    public int hashCode() {
        return 37 * this.number.val.hashCode() + this.ring.hashCode();
    }

    @Override
    public ComplexAlgebraicNumber<C> abs() {
        if (this.signum() < 0) {
            return new ComplexAlgebraicNumber<C>(this.ring, this.number.negate());
        }
        return this;
    }

    @Override
    public ComplexAlgebraicNumber<C> sum(ComplexAlgebraicNumber<C> S) {
        return new ComplexAlgebraicNumber<Complex<C>>(this.ring, this.number.sum((Complex<AlgebraicNumber<Complex<C>>>)((Object)S.number)));
    }

    @Override
    public ComplexAlgebraicNumber<C> sum(GenPolynomial<Complex<C>> c) {
        return new ComplexAlgebraicNumber<Complex<C>>(this.ring, this.number.sum((Complex<GenPolynomial<Complex<C>>>)((Object)c)));
    }

    @Override
    public ComplexAlgebraicNumber<C> sum(AlgebraicNumber<Complex<C>> c) {
        return new ComplexAlgebraicNumber<Complex<C>>(this.ring, this.number.sum((Complex<AlgebraicNumber<Complex<C>>>)((Object)c)));
    }

    @Override
    public ComplexAlgebraicNumber<C> sum(Complex<C> c) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.sum(c));
    }

    @Override
    public ComplexAlgebraicNumber<C> negate() {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.negate());
    }

    @Override
    public ComplexAlgebraicNumber<C> subtract(ComplexAlgebraicNumber<C> S) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.subtract(S.number));
    }

    @Override
    public ComplexAlgebraicNumber<C> divide(ComplexAlgebraicNumber<C> S) {
        return this.multiply((ComplexAlgebraicNumber<C>)S.inverse());
    }

    @Override
    public ComplexAlgebraicNumber<C> inverse() {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.inverse());
    }

    @Override
    public ComplexAlgebraicNumber<C> remainder(ComplexAlgebraicNumber<C> S) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.remainder(S.number));
    }

    public ComplexAlgebraicNumber<C>[] quotientRemainder(ComplexAlgebraicNumber<C> S) {
        return new ComplexAlgebraicNumber[]{this.divide(S), this.remainder(S)};
    }

    @Override
    public ComplexAlgebraicNumber<C> multiply(ComplexAlgebraicNumber<C> S) {
        return new ComplexAlgebraicNumber<Complex<C>>(this.ring, this.number.multiply((Complex<AlgebraicNumber<Complex<C>>>)((Object)S.number)));
    }

    @Override
    public ComplexAlgebraicNumber<C> multiply(Complex<C> c) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.multiply(c));
    }

    @Override
    public ComplexAlgebraicNumber<C> multiply(GenPolynomial<Complex<C>> c) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.multiply(c));
    }

    public ComplexAlgebraicNumber<C> monic() {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.monic());
    }

    @Override
    public ComplexAlgebraicNumber<C> gcd(ComplexAlgebraicNumber<C> S) {
        return new ComplexAlgebraicNumber<C>(this.ring, this.number.gcd(S.number));
    }

    public ComplexAlgebraicNumber<C>[] egcd(ComplexAlgebraicNumber<C> S) {
        AlgebraicNumber<Complex<C>>[] aret = this.number.egcd(S.number);
        ComplexAlgebraicNumber[] ret = new ComplexAlgebraicNumber[]{new ComplexAlgebraicNumber<C>(this.ring, aret[0]), new ComplexAlgebraicNumber<C>(this.ring, aret[1]), new ComplexAlgebraicNumber<C>(this.ring, aret[2])};
        return ret;
    }

    @Override
    public int signum() {
        try {
            Rectangle v = this.ring.engine.invariantRectangle(this.ring.root, this.ring.algebraic.modul, this.number.val);
            this.ring.setRoot(v);
            Complex c = v.getCenter();
            return c.signum();
        }
        catch (InvalidBoundaryException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Complex<BigRational> magnitude() {
        try {
            Rectangle v = this.ring.engine.invariantMagnitudeRectangle(this.ring.root, this.ring.algebraic.modul, this.number.val, this.ring.getEps());
            this.ring.setRoot(v);
            Complex ev = this.ring.engine.complexRectangleMagnitude(v, this.ring.algebraic.modul, this.number.val);
            BigRational er = ((Rational)((Object)((GcdRingElem)ev.getRe()))).getRational();
            BigRational ei = ((Rational)((Object)((GcdRingElem)ev.getIm()))).getRational();
            ComplexRing<BigRational> cr = new ComplexRing<BigRational>(er.factory());
            return new Complex<BigRational>(cr, er, ei);
        }
        catch (InvalidBoundaryException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Complex<BigDecimal> decimalMagnitude() {
        Complex<BigRational> cr = this.magnitude();
        ComplexRing<BigDecimal> dr = new ComplexRing<BigDecimal>(BigDecimal.ZERO);
        return new Complex<BigDecimal>(dr, new BigDecimal(cr.getRe()), new BigDecimal(cr.getIm()));
    }
}

