/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.ps.OrderedPairlist;
import edu.jas.ps.Pair;
import edu.jas.ps.ReductionSeq;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class StandardBaseSeq<C extends RingElem<C>> {
    private static final Logger logger = Logger.getLogger(StandardBaseSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    public final ReductionSeq<C> red;

    public StandardBaseSeq() {
        this(new ReductionSeq());
    }

    public StandardBaseSeq(ReductionSeq<C> red) {
        this.red = red;
    }

    public boolean isSTD(List<MultiVarPowerSeries<C>> F) {
        return this.isSTD(0, F);
    }

    public boolean isSTD(int modv, List<MultiVarPowerSeries<C>> F) {
        if (F == null) {
            return true;
        }
        for (int i = 0; i < F.size(); ++i) {
            MultiVarPowerSeries<C> pi = F.get(i);
            for (int j = i + 1; j < F.size(); ++j) {
                MultiVarPowerSeries<C> h;
                MultiVarPowerSeries<C> s;
                MultiVarPowerSeries<C> pj = F.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj) || (s = this.red.SPolynomial(pi, pj)).isZERO() || (h = this.red.normalform(F, s)).isZERO()) continue;
                System.out.println("pi = " + pi + ", pj = " + pj);
                System.out.println("s  = " + s + ", h = " + h);
                return false;
            }
        }
        return true;
    }

    public List<MultiVarPowerSeries<C>> STD(List<MultiVarPowerSeries<C>> F) {
        return this.STD(0, F);
    }

    public List<MultiVarPowerSeries<C>> STD(int modv, List<MultiVarPowerSeries<C>> F) {
        MultiVarPowerSeries<C> p = null;
        List<MultiVarPowerSeries<C>> G = new ArrayList<MultiVarPowerSeries<C>>();
        OrderedPairlist<C> pairlist = null;
        int l = F.size();
        ListIterator<MultiVarPowerSeries<C>> it = F.listIterator();
        while (it.hasNext()) {
            p = it.next();
            if (!p.isZERO()) {
                if (p.isUnit()) {
                    G.clear();
                    G.add(p);
                    return G;
                }
                G.add(p);
                if (pairlist == null) {
                    pairlist = new OrderedPairlist<C>(modv, p.ring);
                    if (!p.ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                pairlist.put(p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        while (pairlist.hasNext()) {
            MultiVarPowerSeries<C> H;
            MultiVarPowerSeries<C> S;
            Pair pair = pairlist.removeNext();
            if (pair == null) continue;
            MultiVarPowerSeries pi = pair.pi;
            MultiVarPowerSeries pj = pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + pi));
                logger.debug((Object)("pj    = " + pj));
            }
            if ((S = this.red.SPolynomial(pi, pj)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isInfoEnabled()) {
                ExpVector es = S.orderExpVector();
                logger.info((Object)("ht(S) = " + es.toString(S.ring.vars) + ", " + es));
            }
            if ((H = this.red.normalform(G, S)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (logger.isInfoEnabled()) {
                ExpVector eh = H.orderExpVector();
                logger.info((Object)("ht(H) = " + eh.toString(S.ring.vars) + ", " + eh));
            }
            if (H.isUnit()) {
                G.clear();
                G.add(H);
                return G;
            }
            if (logger.isDebugEnabled()) {
                logger.info((Object)("H = " + H));
            }
            ++l;
            G.add(H);
            pairlist.put(H);
        }
        logger.debug((Object)("#sequential list = " + G.size()));
        G = this.minimalSTD(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    public List<MultiVarPowerSeries<C>> minimalSTD(List<MultiVarPowerSeries<C>> Gp) {
        if (Gp == null || Gp.size() <= 1) {
            return Gp;
        }
        ArrayList<MultiVarPowerSeries<C>> G = new ArrayList<MultiVarPowerSeries<C>>(Gp.size());
        for (MultiVarPowerSeries<C> a : Gp) {
            if (a == null || a.isZERO()) continue;
            a = a.monic();
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList F = new ArrayList(G.size());
        while (G.size() > 0) {
            MultiVarPowerSeries<C> a = (MultiVarPowerSeries<C>)G.remove(0);
            if (this.red.isTopReducible(G, a) || this.red.isTopReducible(F, a)) {
                if (!this.debug) continue;
                System.out.println("dropped " + a);
                ArrayList<MultiVarPowerSeries<C>> ff = new ArrayList<MultiVarPowerSeries<C>>(G);
                ff.addAll(F);
                if ((a = this.red.normalform(ff, a)).isZERO()) continue;
                System.out.println("error, nf(a) " + a);
                continue;
            }
            F.add(a);
        }
        G = F;
        return G;
    }
}

