/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.util.CartesianProductLong;
import edu.jas.util.LongIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class ExpVectorIterator
implements Iterator<ExpVector> {
    ExpVector current;
    Iterator<List<Long>> liter;
    protected int totalDegree;
    protected boolean empty;
    final long upperBound;
    final boolean infinite;
    final int nvar;

    public ExpVectorIterator(int nv) {
        this(nv, true, Long.MAX_VALUE);
    }

    public ExpVectorIterator(int nv, long ub) {
        this(nv, false, ub);
    }

    protected ExpVectorIterator(int nv, boolean inf, long ub) {
        this.infinite = inf;
        this.upperBound = ub;
        if (this.upperBound < 0L) {
            throw new IllegalArgumentException("negative upper bound not allowed");
        }
        this.totalDegree = 0;
        if (!this.infinite) {
            this.totalDegree = (int)this.upperBound;
        }
        LongIterable li = new LongIterable();
        li.setNonNegativeIterator();
        li.setUpperBound(this.totalDegree);
        ArrayList<LongIterable> tlist = new ArrayList<LongIterable>(nv);
        for (int i = 0; i < nv; ++i) {
            tlist.add(li);
        }
        CartesianProductLong ib = new CartesianProductLong(tlist, this.totalDegree);
        this.liter = ib.iterator();
        this.empty = (long)this.totalDegree > this.upperBound || !this.liter.hasNext();
        this.current = ExpVector.create(nv);
        if (!this.empty) {
            List<Long> el = this.liter.next();
            this.current = ExpVector.create(el);
        }
        this.nvar = nv;
    }

    @Override
    public synchronized boolean hasNext() {
        return !this.empty;
    }

    @Override
    public synchronized ExpVector next() {
        ExpVector res = this.current;
        if (this.liter.hasNext()) {
            List<Long> el = this.liter.next();
            this.current = ExpVector.create(el);
            return res;
        }
        if ((long)this.totalDegree >= this.upperBound) {
            this.empty = true;
            return res;
        }
        ++this.totalDegree;
        if ((long)this.totalDegree >= this.upperBound && !this.infinite) {
            throw new NoSuchElementException("invalid call of next()");
        }
        LongIterable li = new LongIterable();
        li.setNonNegativeIterator();
        li.setUpperBound(this.totalDegree);
        ArrayList<LongIterable> tlist = new ArrayList<LongIterable>(this.nvar);
        for (int i = 0; i < this.nvar; ++i) {
            tlist.add(li);
        }
        CartesianProductLong ib = new CartesianProductLong(tlist, this.totalDegree);
        this.liter = ib.iterator();
        List<Long> el = this.liter.next();
        this.current = ExpVector.create(el);
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("cannnot remove elements");
    }
}

