/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RelationGenerator;
import edu.jas.poly.RelationTable;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class WeylRelationsIterated<C extends RingElem<C>>
implements RelationGenerator<C> {
    private final GenSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(WeylRelationsIterated.class);

    public WeylRelationsIterated() {
        this.ring = null;
    }

    public WeylRelationsIterated(GenSolvablePolynomialRing<C> r) {
        if (r == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        this.ring = r;
        if (this.ring.nvar <= 1 || this.ring.nvar % 2 != 0) {
            throw new IllegalArgumentException("WeylRelations, wrong nvar = " + this.ring.nvar);
        }
    }

    public void generate() {
        if (this.ring == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        this.generate(this.ring);
    }

    @Override
    public void generate(GenSolvablePolynomialRing<C> ring) {
        if (ring == null) {
            throw new IllegalArgumentException("WeylRelations, ring == null");
        }
        if (ring.nvar <= 1 || ring.nvar % 2 != 0) {
            throw new IllegalArgumentException("WeylRelations, wrong nvar = " + ring.nvar);
        }
        RelationTable table = ring.table;
        int r = ring.nvar;
        GenPolynomial one = ((GenSolvablePolynomial)ring.getONE()).copy();
        GenPolynomial zero = ((GenSolvablePolynomial)ring.getZERO()).copy();
        for (int i = 1; i <= r; i += 2) {
            ExpVector f = ExpVector.create(r, i, 1L);
            int j = i - 1;
            ExpVector e = ExpVector.create(r, j, 1L);
            ExpVector ef = e.sum(f);
            GenPolynomial b = ((GenSolvablePolynomial)one).multiply(ef);
            GenSolvablePolynomial rel = (GenSolvablePolynomial)b.sum(one);
            if (rel.isZERO()) {
                logger.info((Object)("ring = " + ring));
                logger.info((Object)("one  = " + one));
                logger.info((Object)("zero = " + zero));
                logger.info((Object)("b    = " + b));
                logger.info((Object)("rel  = " + rel));
                throw new RuntimeException("rel.isZERO()");
            }
            table.update(e, f, rel);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nWeyl relations = " + table));
        }
    }
}

