/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.Quotient;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class QuotientRing<C extends RingElem<C>>
implements RingFactory<Quotient<C>>,
QuotPairFactory<C, Quotient<C>> {
    private static final Logger logger = Logger.getLogger(QuotientRing.class);
    private boolean debug = logger.isDebugEnabled();
    public final RingFactory<C> ring;

    public QuotientRing(RingFactory<C> r) {
        this.ring = r;
    }

    @Override
    public RingFactory<C> pairFactory() {
        return this.ring;
    }

    @Override
    public Quotient<C> create(C n) {
        return new Quotient<C>(this, n);
    }

    @Override
    public Quotient<C> create(C n, C d) {
        return new Quotient<C>(this, n, d);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite();
    }

    @Override
    public Quotient<C> copy(Quotient<C> c) {
        return new Quotient(c.ring, c.num, c.den, true);
    }

    @Override
    public Quotient<C> getZERO() {
        return new Quotient<RingElem>(this, (RingElem)this.ring.getZERO());
    }

    @Override
    public Quotient<C> getONE() {
        return new Quotient<RingElem>(this, (RingElem)this.ring.getONE());
    }

    @Override
    public List<Quotient<C>> generators() {
        List rgens = this.ring.generators();
        ArrayList<Quotient<C>> gens = new ArrayList<Quotient<C>>(rgens.size());
        for (RingElem c : rgens) {
            gens.add(new Quotient<RingElem>(this, c));
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        return this.ring.isAssociative();
    }

    @Override
    public boolean isField() {
        return true;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public Quotient<C> fromInteger(BigInteger a) {
        return new Quotient<RingElem>(this, (RingElem)this.ring.fromInteger(a));
    }

    @Override
    public Quotient<C> fromInteger(long a) {
        return new Quotient<RingElem>(this, (RingElem)this.ring.fromInteger(a));
    }

    public String toString() {
        return "Quotient[ " + this.ring.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "QuotientRing(" + this.ring.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof QuotientRing)) {
            return false;
        }
        QuotientRing a = null;
        try {
            a = (QuotientRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.ring.equals(a.ring);
    }

    public int hashCode() {
        int h = this.ring.hashCode();
        return h;
    }

    @Override
    public Quotient<C> random(int n) {
        RingElem r = (RingElem)this.ring.random(n);
        RingElem s = (RingElem)this.ring.random(n);
        while (s.isZERO()) {
            s = (RingElem)this.ring.random(n);
        }
        return new Quotient<RingElem>(this, r, s, false);
    }

    @Override
    public Quotient<C> random(int n, Random rnd) {
        RingElem r = (RingElem)this.ring.random(n, rnd);
        RingElem s = (RingElem)this.ring.random(n, rnd);
        while (s.isZERO()) {
            s = (RingElem)this.ring.random(n, rnd);
        }
        return new Quotient<RingElem>(this, r, s, false);
    }

    @Override
    public Quotient<C> parse(String s) {
        RingElem x = (RingElem)this.ring.parse(s);
        return new Quotient<RingElem>(this, x);
    }

    @Override
    public Quotient<C> parse(Reader r) {
        RingElem x = (RingElem)this.ring.parse(r);
        if (this.debug) {
            logger.debug((Object)("x = " + x));
        }
        return new Quotient<RingElem>(this, x);
    }
}

