/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class OrderedModuleList<C extends RingElem<C>>
extends ModuleList<C> {
    public OrderedModuleList(GenPolynomialRing<C> r, List<List<GenPolynomial<C>>> l) {
        super(r, OrderedModuleList.sort(r, ModuleList.padCols(r, l)));
    }

    @Override
    public boolean equals(Object m) {
        if (!super.equals(m)) {
            return false;
        }
        OrderedModuleList ml = null;
        try {
            ml = (OrderedModuleList)m;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return ml != null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static <C extends RingElem<C>> List<List<GenPolynomial<C>>> sort(GenPolynomialRing<C> r, List<List<GenPolynomial<C>>> l) {
        if (l == null) {
            return l;
        }
        if (l.size() <= 1) {
            return l;
        }
        final TermOrder.EVComparator evc = r.tord.getAscendComparator();
        Comparator cmp = new Comparator<List<GenPolynomial<C>>>(){

            @Override
            public int compare(List<GenPolynomial<C>> l1, List<GenPolynomial<C>> l2) {
                int c = 0;
                for (int i = 0; i < l1.size(); ++i) {
                    ExpVector e2;
                    GenPolynomial p1 = l1.get(i);
                    GenPolynomial p2 = l2.get(i);
                    ExpVector e1 = p1.leadingExpVector();
                    if (e1 == (e2 = p2.leadingExpVector())) continue;
                    if (e1 == null && e2 != null) {
                        return -1;
                    }
                    if (e1 != null && e2 == null) {
                        return 1;
                    }
                    if (e1 == null || e2 == null) continue;
                    if (e1.length() != e2.length()) {
                        if (e1.length() > e2.length()) {
                            return 1;
                        }
                        return -1;
                    }
                    c = evc.compare(e1, e2);
                    if (c == 0) continue;
                    return c;
                }
                return c;
            }
        };
        List[] s = null;
        try {
            s = new List[l.size()];
            int i = 0;
            for (List<GenPolynomial<C>> p : l) {
                s[i++] = p;
            }
            Arrays.sort(s, cmp);
            return new ArrayList<List<GenPolynomial<C>>>(Arrays.asList(s));
        }
        catch (ClassCastException ok) {
            System.out.println("Warning: polynomials not sorted");
            return l;
        }
    }
}

