/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import java.util.ArrayList;
import java.util.List;

class CoeffToRecAlg<C extends GcdRingElem<C>>
implements UnaryFunctor<C, AlgebraicNumber<C>> {
    protected final List<AlgebraicNumberRing<C>> lfac;
    final int depth;

    public CoeffToRecAlg(int depth, AlgebraicNumberRing<C> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        AlgebraicNumberRing afac = fac;
        this.depth = depth;
        this.lfac = new ArrayList<AlgebraicNumberRing<C>>(this.depth);
        this.lfac.add(fac);
        for (int i = 1; i < this.depth; ++i) {
            RingFactory rf = afac.ring.coFac;
            if (!(rf instanceof AlgebraicNumberRing)) {
                throw new IllegalArgumentException("fac depth to low");
            }
            afac = (AlgebraicNumberRing)rf;
            this.lfac.add(afac);
        }
    }

    @Override
    public AlgebraicNumber<C> eval(C c) {
        if (c == null) {
            return this.lfac.get(0).getZERO();
        }
        Object ac = c;
        AlgebraicNumberRing<C> af = this.lfac.get(this.lfac.size() - 1);
        AbelianGroupElem zero = af.ring.getZERO();
        AlgebraicNumber<C> an = new AlgebraicNumber<C>(af, ((GenPolynomial)zero).sum(ac));
        for (int i = this.lfac.size() - 2; i >= 0; --i) {
            af = this.lfac.get(i);
            zero = af.ring.getZERO();
            ac = an;
            an = new AlgebraicNumber<C>(af, ((GenPolynomial)zero).sum(ac));
        }
        return an;
    }
}

