/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.integrate.Integral;
import edu.jas.integrate.LogIntegral;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QuotIntegral<C extends GcdRingElem<C>>
implements Serializable {
    public final Quotient<C> quot;
    public final List<Quotient<C>> rational;
    public final List<LogIntegral<C>> logarithm;

    public QuotIntegral(Integral<C> ri) {
        this(new QuotientRing(ri.den.ring), ri);
    }

    public QuotIntegral(QuotientRing<C> r, Integral<C> ri) {
        this(new Quotient<C>(r, ri.num, ri.den), ri.pol, ri.rational, ri.logarithm);
    }

    public QuotIntegral(Quotient<C> r, GenPolynomial<C> p, List<GenPolynomial<C>> rat) {
        this(r, p, rat, new ArrayList<LogIntegral<C>>());
    }

    public QuotIntegral(Quotient<C> r, GenPolynomial<C> p, List<GenPolynomial<C>> rat, List<LogIntegral<C>> log) {
        this.quot = r;
        QuotientRing qr = r.ring;
        this.rational = new ArrayList<Quotient<C>>();
        if (!p.isZERO()) {
            this.rational.add(new Quotient(qr, p));
        }
        for (int i = 0; i < rat.size(); ++i) {
            GenPolynomial<C> rn = rat.get(i++);
            GenPolynomial<C> rd = rat.get(i);
            this.rational.add(new Quotient(qr, rn, rd));
        }
        this.logarithm = log;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("integral( " + this.quot.toString() + " )");
        sb.append(" =\n");
        boolean first = true;
        if (this.rational.size() != 0) {
            for (int i = 0; i < this.rational.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" + ");
                }
                sb.append("(" + this.rational.get(i) + ")");
            }
        }
        if (this.logarithm.size() != 0) {
            if (this.rational.size() != 0) {
                sb.append(" + ");
            }
            first = true;
            for (LogIntegral<C> pf : this.logarithm) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" + ");
                }
                sb.append(pf);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public int hashCode() {
        int h = this.quot.hashCode();
        h = h * 37 + this.rational.hashCode();
        h = h * 37 + this.logarithm.hashCode();
        return h;
    }

    public boolean equals(Object B) {
        QuotIntegral b = null;
        try {
            b = (QuotIntegral)B;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (b == null) {
            return false;
        }
        return this.quot.equals(b.quot) && this.rational.equals(b.rational) && this.logarithm.equals(b.logarithm);
    }
}

