/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gbmod.QuotSolvablePolynomial;
import edu.jas.gbmod.SolvableQuotient;
import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class QuotSolvablePolynomialRing<C extends GcdRingElem<C>>
extends GenSolvablePolynomialRing<SolvableQuotient<C>> {
    public final RecSolvablePolynomialRing<C> polCoeff;
    public final QuotSolvablePolynomial<C> ZERO;
    public final QuotSolvablePolynomial<C> ONE;
    private static final Logger logger = Logger.getLogger(QuotSolvablePolynomialRing.class);

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, int n) {
        this(cf, n, new TermOrder(), (String[])null, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, int n, RelationTable<SolvableQuotient<C>> rt) {
        this(cf, n, new TermOrder(), (String[])null, rt);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, int n, TermOrder t) {
        this(cf, n, t, (String[])null, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, int n, TermOrder t, RelationTable<SolvableQuotient<C>> rt) {
        this(cf, n, t, (String[])null, rt);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, int n, TermOrder t, String[] v) {
        this(cf, n, t, v, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, TermOrder t, String[] v) {
        this(cf, v.length, t, v, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, String[] v) {
        this(cf, v.length, new TermOrder(), v, (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, int n, TermOrder t, String[] v, RelationTable<SolvableQuotient<C>> rt) {
        super(cf, n, t, v, rt);
        SolvableQuotientRing cfring = (SolvableQuotientRing)cf;
        this.polCoeff = new RecSolvablePolynomialRing(cfring.ring, n, t, v);
        if (this.table.size() > 0) {
            ExpVector e = null;
            ExpVector f = null;
            GenSolvablePolynomial p = null;
            this.polCoeff.table.update(e, f, p);
        }
        this.ZERO = new QuotSolvablePolynomial(this);
        SolvableQuotient coeff = (SolvableQuotient)this.coFac.getONE();
        this.ONE = new QuotSolvablePolynomial(this, coeff, this.evzero);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, GenSolvablePolynomialRing o) {
        this(cf, o.nvar, o.tord, o.getVars(), (RelationTable<SolvableQuotient<C>>)null);
    }

    public QuotSolvablePolynomialRing(RingFactory<SolvableQuotient<C>> cf, QuotSolvablePolynomialRing o) {
        this(cf, (GenSolvablePolynomialRing)o);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = PrettyPrint.isTrue() ? res + "\n" + this.polCoeff.coeffTable.toString(this.vars) : res + ", #rel = " + this.table.size() + " + " + this.polCoeff.coeffTable.size();
        return res;
    }

    @Override
    public String toScript() {
        String rel;
        StringBuffer s = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                s.append("SolvPolyRing.new(");
                break;
            }
            default: {
                s.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            s.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            s.append(this.coFac.toScript().trim());
        }
        s.append(",\"" + this.varsToString() + "\",");
        String to = this.tord.toString();
        if (this.tord.getEvord() == 2) {
            to = "PolyRing.lex";
        }
        if (this.tord.getEvord() == 4) {
            to = "PolyRing.grad";
        }
        s.append(to);
        if (this.table.size() > 0) {
            rel = this.table.toScript();
            s.append(",rel=");
            s.append(rel);
        }
        if (this.polCoeff.coeffTable.size() > 0) {
            rel = this.polCoeff.coeffTable.toScript();
            s.append(",coeffrel=");
            s.append(rel);
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof QuotSolvablePolynomialRing)) {
            return false;
        }
        QuotSolvablePolynomialRing oring = null;
        try {
            oring = (QuotSolvablePolynomialRing)other;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (oring == null) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.polCoeff.coeffTable.equals(oring.polCoeff.coeffTable);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        h = 37 * h + this.table.hashCode();
        h = 37 * h + this.polCoeff.coeffTable.hashCode();
        return h;
    }

    @Override
    public QuotSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public QuotSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.polCoeff.coeffTable.size() == 0) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        List gens = this.generators();
        int ngen = gens.size();
        for (int i = 0; i < ngen; ++i) {
            QuotSolvablePolynomial Xi = (QuotSolvablePolynomial)gens.get(i);
            for (int j = i + 1; j < ngen; ++j) {
                QuotSolvablePolynomial Xj = (QuotSolvablePolynomial)gens.get(j);
                for (int k = j + 1; k < ngen; ++k) {
                    QuotSolvablePolynomial q;
                    QuotSolvablePolynomial Xk = (QuotSolvablePolynomial)gens.get(k);
                    QuotSolvablePolynomial p = Xk.multiply(Xj).multiply(Xi);
                    if (p.equals(q = Xk.multiply(Xj.multiply(Xi)))) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Xk = " + Xk + ", Xj = " + Xj + ", Xi = " + Xi));
                        logger.info((Object)("p = ( Xk * Xj ) * Xi = " + p));
                        logger.info((Object)("q = Xk * ( Xj * Xi ) = " + q));
                        logger.info((Object)("q-p = " + p.subtract(q)));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public QuotSolvablePolynomial<C> fromInteger(long a) {
        return new QuotSolvablePolynomial(this, (SolvableQuotient)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public QuotSolvablePolynomial<C> fromInteger(BigInteger a) {
        return new QuotSolvablePolynomial(this, (SolvableQuotient)this.coFac.fromInteger(a), this.evzero);
    }

    @Override
    public QuotSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public QuotSolvablePolynomial<C> random(int n, Random rnd) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, rnd);
        }
        return this.random(5, n, 3, 0.3f, rnd);
    }

    @Override
    public QuotSolvablePolynomial<C> random(int k, int l, int d, float q) {
        return this.random(k, l, d, q, random);
    }

    @Override
    public QuotSolvablePolynomial<C> random(int k, int l, int d, float q, Random rnd) {
        GenSolvablePolynomial r = this.getZERO();
        for (int i = 0; i < l; ++i) {
            ExpVector e = ExpVector.EVRAND(this.nvar, d, q, rnd);
            SolvableQuotient a = (SolvableQuotient)this.coFac.random(k, rnd);
            r = (QuotSolvablePolynomial)r.sum(a, e);
        }
        return r;
    }

    @Override
    public QuotSolvablePolynomial<C> copy(QuotSolvablePolynomial<C> c) {
        return new QuotSolvablePolynomial(this, c.getMap());
    }

    @Override
    public QuotSolvablePolynomial<C> parse(String s) {
        return this.parse(new StringReader(s));
    }

    @Override
    public QuotSolvablePolynomial<C> parse(Reader r) {
        GenPolynomialTokenizer pt = new GenPolynomialTokenizer(this, r);
        QuotSolvablePolynomial p = null;
        try {
            GenSolvablePolynomial s = pt.nextSolvablePolynomial();
            p = new QuotSolvablePolynomial(this, s);
        }
        catch (IOException e) {
            logger.error((Object)(e.toString() + " parse " + this));
            p = this.ZERO;
        }
        return p;
    }

    @Override
    public QuotSolvablePolynomial<C> univariate(int i) {
        return (QuotSolvablePolynomial)super.univariate(i);
    }

    @Override
    public QuotSolvablePolynomial<C> univariate(int i, long e) {
        return (QuotSolvablePolynomial)super.univariate(i, e);
    }

    @Override
    public QuotSolvablePolynomial<C> univariate(int modv, int i, long e) {
        return (QuotSolvablePolynomial)super.univariate(modv, i, e);
    }

    public List<QuotSolvablePolynomial<C>> recUnivariateList() {
        return this.univariateList(0, 1L);
    }

    public List<QuotSolvablePolynomial<C>> recUnivariateList(int modv) {
        return this.univariateList(modv, 1L);
    }

    public List<QuotSolvablePolynomial<C>> recUnivariateList(int modv, long e) {
        ArrayList<QuotSolvablePolynomial<C>> pols = new ArrayList<QuotSolvablePolynomial<C>>(this.nvar);
        int nm = this.nvar - modv;
        for (int i = 0; i < nm; ++i) {
            GenSolvablePolynomial p = this.univariate(modv, nm - 1 - i, e);
            pols.add((QuotSolvablePolynomial<C>)p);
        }
        return pols;
    }

    @Override
    public QuotSolvablePolynomialRing<C> extend(int i) {
        GenPolynomialRing pfac = super.extend(i);
        QuotSolvablePolynomialRing<C> spfac = new QuotSolvablePolynomialRing<C>(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.table.extend(this.table);
        spfac.polCoeff.coeffTable.extend(this.polCoeff.coeffTable);
        return spfac;
    }

    @Override
    public QuotSolvablePolynomialRing<C> contract(int i) {
        GenPolynomialRing pfac = super.contract(i);
        QuotSolvablePolynomialRing<C> spfac = new QuotSolvablePolynomialRing<C>(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.table.contract(this.table);
        spfac.polCoeff.coeffTable.contract(this.polCoeff.coeffTable);
        return spfac;
    }

    @Override
    public QuotSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public QuotSolvablePolynomialRing<C> reverse(boolean partial) {
        GenPolynomialRing pfac = super.reverse(partial);
        QuotSolvablePolynomialRing<C> spfac = new QuotSolvablePolynomialRing<C>(pfac.coFac, pfac.nvar, pfac.tord, pfac.getVars());
        spfac.partial = partial;
        spfac.table.reverse(this.table);
        spfac.polCoeff.coeffTable.reverse(this.polCoeff.coeffTable);
        return spfac;
    }

    public QuotSolvablePolynomial<C> fromPolyCoefficients(GenSolvablePolynomial<GenPolynomial<C>> A) {
        GenSolvablePolynomial B = ((QuotSolvablePolynomial)this.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        RingFactory cfac = this.coFac;
        SolvableQuotientRing qfac = (SolvableQuotientRing)cfac;
        for (Map.Entry y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenSolvablePolynomial a = (GenSolvablePolynomial)y.getValue();
            SolvableQuotient p = new SolvableQuotient(qfac, a);
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(QuotSolvablePolynomial<C> A) {
        GenSolvablePolynomial B = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        for (Map.Entry y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            SolvableQuotient a = (SolvableQuotient)y.getValue();
            if (!a.den.isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + a);
            }
            GenSolvablePolynomial p = a.num;
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }

    public RecSolvablePolynomial<C> toPolyCoefficients(GenPolynomial<SolvableQuotient<C>> A) {
        GenSolvablePolynomial B = ((RecSolvablePolynomial)this.polCoeff.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        for (Map.Entry<ExpVector, SolvableQuotient<C>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            SolvableQuotient<C> a = y.getValue();
            if (!a.den.isONE()) {
                throw new IllegalArgumentException("den != 1 not supported: " + a);
            }
            GenSolvablePolynomial p = a.num;
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }
}

