/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPair;
import edu.jas.gb.CriticalPairList;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import java.util.List;
import org.apache.log4j.Logger;

class TwosidedSolvableReducerSeqPair<C extends RingElem<C>>
implements Runnable {
    private final List<GenSolvablePolynomial<C>> X;
    private final List<GenSolvablePolynomial<C>> G;
    private final CriticalPairList<C> pairlist;
    private final Terminator pool;
    private final SolvableReductionPar<C> sred;
    private static final Logger logger = Logger.getLogger(TwosidedSolvableReducerSeqPair.class);
    private static final boolean debug = logger.isDebugEnabled();

    TwosidedSolvableReducerSeqPair(Terminator fin, List<GenSolvablePolynomial<C>> X, List<GenSolvablePolynomial<C>> G, CriticalPairList<C> L) {
        this.pool = fin;
        this.X = X;
        this.G = G;
        this.pairlist = L;
        this.sred = new SolvableReductionPar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean set = false;
        int reduction = 0;
        int sleeps = 0;
        while (this.pairlist.hasNext() || this.pool.hasJobs()) {
            GenSolvablePolynomial S;
            CriticalPair<C> pair;
            while (!this.pairlist.hasNext()) {
                this.pairlist.update();
                this.pool.beIdle();
                set = true;
                try {
                    if (++sleeps % 10 == 0) {
                        logger.info((Object)" reducer is sleeping");
                    } else {
                        logger.debug((Object)"r");
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (this.pool.hasJobs()) continue;
            }
            if (!this.pairlist.hasNext() && !this.pool.hasJobs()) break;
            if (set) {
                this.pool.notIdle();
                set = false;
            }
            if ((pair = this.pairlist.getNext()) == null) {
                this.pairlist.update();
                continue;
            }
            if (debug) {
                logger.debug((Object)("pi = " + pair.pi));
                logger.debug((Object)("pj = " + pair.pj));
            }
            if ((S = this.sred.leftSPolynomial((GenSolvablePolynomial)pair.pi, (GenSolvablePolynomial)pair.pj)).isZERO()) {
                this.pairlist.record(pair, S);
                continue;
            }
            if (debug) {
                logger.debug((Object)("ht(S) = " + S.leadingExpVector()));
            }
            GenPolynomial H = this.sred.leftNormalform(this.G, S);
            ++reduction;
            if (H.isZERO()) {
                this.pairlist.record(pair, H);
                continue;
            }
            if (debug) {
                logger.debug((Object)("ht(H) = " + H.leadingExpVector()));
            }
            if ((H = ((GenSolvablePolynomial)H).monic()).isONE()) {
                this.pairlist.putOne();
                List<GenSolvablePolynomial<C>> e = this.G;
                synchronized (e) {
                    this.G.clear();
                    this.G.add((GenSolvablePolynomial<C>)H);
                }
                this.pool.allIdle();
                return;
            }
            if (debug) {
                logger.debug((Object)("H = " + H));
            }
            List<GenSolvablePolynomial<C>> e = this.G;
            synchronized (e) {
                this.G.add((GenSolvablePolynomial<C>)H);
            }
            this.pairlist.update(pair, H);
            for (int j = 0; j < this.X.size(); ++j) {
                List<GenSolvablePolynomial<C>> list;
                GenSolvablePolynomial<C> x = this.X.get(j);
                GenPolynomial p = ((GenSolvablePolynomial)H).multiply(x);
                if ((p = this.sred.leftNormalform((List<GenSolvablePolynomial<GenSolvablePolynomial<C>>>)this.G, (GenSolvablePolynomial<GenSolvablePolynomial<C>>)p)).isZERO()) continue;
                if ((p = ((GenSolvablePolynomial)p).monic()).isONE()) {
                    list = this.G;
                    synchronized (list) {
                        this.G.clear();
                        this.G.add((GenSolvablePolynomial<C>)p);
                    }
                    this.pool.allIdle();
                    return;
                }
                list = this.G;
                synchronized (list) {
                    this.G.add((GenSolvablePolynomial<C>)p);
                }
                this.pairlist.put(p);
            }
        }
        logger.info((Object)("terminated, done " + reduction + " reductions"));
    }
}

