/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessPoly;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

class ReducerServerEC<C extends RingElem<C>>
implements Runnable {
    private final Terminator pool;
    private final ChannelFactory cf;
    private SocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final PairList<C> pairlist;
    private static final Logger logger = Logger.getLogger(ReducerServerEC.class);

    ReducerServerEC(Terminator fin, ChannelFactory cf, DistHashTable<Integer, GenPolynomial<C>> dl, List<GenPolynomial<C>> G, PairList<C> L) {
        this.pool = fin;
        this.cf = cf;
        this.theList = dl;
        this.pairlist = L;
    }

    @Override
    public void run() {
        block30: {
            logger.info((Object)("reducer server running with " + this.cf));
            try {
                this.pairChannel = this.cf.getChannel();
            }
            catch (InterruptedException e) {
                logger.debug((Object)"get pair channel interrupted");
                e.printStackTrace();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pairChannel = " + this.pairChannel));
            }
            GenPolynomial H = null;
            boolean set = false;
            boolean goon = true;
            int polIndex = -1;
            int red = 0;
            int sleeps = 0;
            while (goon) {
                logger.info((Object)"receive request");
                Object req = null;
                try {
                    req = this.pairChannel.receive();
                }
                catch (IOException e) {
                    goon = false;
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    goon = false;
                    e.printStackTrace();
                }
                if (req == null) {
                    goon = false;
                    break;
                }
                if (!(req instanceof GBTransportMessReq)) {
                    goon = false;
                    break;
                }
                logger.debug((Object)"find pair");
                while (!this.pairlist.hasNext()) {
                    if (!set) {
                        this.pool.beIdle();
                        set = true;
                    }
                    if (!this.pool.hasJobs() && !this.pairlist.hasNext()) {
                        goon = false;
                        break;
                    }
                    try {
                        if (++sleeps % 10 == 0) {
                            logger.info((Object)("reducer is sleeping, pool = " + this.pool));
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        goon = false;
                        break;
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    goon = false;
                    break;
                }
                if (!this.pairlist.hasNext() && !this.pool.hasJobs()) {
                    goon = false;
                    break;
                }
                if (set) {
                    set = false;
                    this.pool.notIdle();
                }
                Pair<C> pair = this.pairlist.removeNext();
                logger.debug((Object)("send pair = " + pair));
                GBTransportMess msg = null;
                msg = pair != null ? new GBTransportMessPairIndex(pair) : new GBTransportMess();
                try {
                    this.pairChannel.send(msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    goon = false;
                    break;
                }
                logger.debug((Object)("#distributed list = " + this.theList.size()));
                Object rh = null;
                try {
                    rh = this.pairChannel.receive();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    goon = false;
                    break;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    goon = false;
                    break;
                }
                if (rh == null) {
                    if (pair == null) continue;
                    pair.setZero();
                    continue;
                }
                if (!(rh instanceof GBTransportMessPoly)) continue;
                ++red;
                H = ((GBTransportMessPoly)rh).pol;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("H = " + H));
                }
                if (H == null) {
                    if (pair == null) continue;
                    pair.setZero();
                    continue;
                }
                if (H.isZERO()) {
                    pair.setZero();
                    continue;
                }
                if (H.isONE()) {
                    polIndex = this.pairlist.putOne();
                    this.theList.putWait(polIndex, H);
                    goon = false;
                    break;
                }
                polIndex = this.pairlist.put(H);
                this.theList.putWait(polIndex, H);
            }
            logger.info((Object)("terminated, done " + red + " reductions"));
            logger.debug((Object)"send end");
            try {
                this.pairChannel.send(new GBTransportMessEnd());
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block30;
                e.printStackTrace();
            }
        }
        this.pool.beIdle();
        this.pairChannel.close();
    }
}

