/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducer;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.PairList;
import edu.jas.gb.Reducer;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseParallel<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseParallel.class);
    protected final int threads;
    protected final transient ThreadPool pool;

    public GroebnerBaseParallel() {
        this(2);
    }

    public GroebnerBaseParallel(int threads) {
        this(threads, new ThreadPool(threads));
    }

    public GroebnerBaseParallel(int threads, Reduction<C> red) {
        this(threads, new ThreadPool(threads), red);
    }

    public GroebnerBaseParallel(int threads, PairList<C> pl) {
        this(threads, new ThreadPool(threads), new ReductionPar(), pl);
    }

    public GroebnerBaseParallel(int threads, ThreadPool pool) {
        this(threads, pool, new ReductionPar());
    }

    public GroebnerBaseParallel(int threads, ThreadPool pool, Reduction<C> red) {
        this(threads, pool, red, new OrderedPairlist());
    }

    public GroebnerBaseParallel(int threads, Reduction<C> red, PairList<C> pl) {
        this(threads, new ThreadPool(threads), red, pl);
    }

    public GroebnerBaseParallel(int threads, ThreadPool pool, Reduction<C> red, PairList<C> pl) {
        super(red, pl);
        if (!(red instanceof ReductionPar)) {
            logger.warn((Object)"parallel GB should use parallel aware reduction");
        }
        if (threads < 1) {
            threads = 1;
        }
        this.threads = threads;
        this.pool = pool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int s = this.pool.cancel();
        return s;
    }

    @Override
    public List<GenPolynomial<C>> GB(int modv, List<GenPolynomial<C>> F) {
        List<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>();
        PairList<C> pairlist = null;
        int l = F.size();
        ListIterator<GenPolynomial<C>> it = F.listIterator();
        while (it.hasNext()) {
            GenPolynomial<C> p = it.next();
            if (p.length() > 0) {
                if ((p = p.monic()).isONE()) {
                    G.clear();
                    G.add(p);
                    return G;
                }
                G.add(p);
                if (pairlist == null) {
                    pairlist = this.strategy.create(modv, p.ring);
                    if (!p.ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                pairlist.put(p);
                continue;
            }
            --l;
        }
        if (l <= 1) {
            return G;
        }
        logger.info((Object)("start " + pairlist));
        Terminator fin = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            Reducer<C> R = new Reducer<C>(fin, G, pairlist);
            this.pool.addJob(R);
        }
        fin.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug((Object)("#parallel list = " + G.size()));
        G = this.minimalGB(G);
        logger.info((Object)("" + pairlist));
        return G;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> Fp) {
        GenPolynomial<C> a;
        ArrayList<GenPolynomial<C>> G = new ArrayList<GenPolynomial<C>>(Fp.size());
        ListIterator<GenPolynomial<Object>> it = Fp.listIterator();
        while (it.hasNext()) {
            a = it.next();
            if (a.length() == 0) continue;
            G.add(a);
        }
        if (G.size() <= 1) {
            return G;
        }
        ArrayList<GenPolynomial<C>> F = new ArrayList<GenPolynomial<C>>(G.size());
        while (G.size() > 0) {
            ExpVector f;
            GenPolynomial<Object> p;
            a = G.remove(0);
            ExpVector e = a.leadingExpVector();
            it = G.listIterator();
            boolean mt = false;
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            it = F.listIterator();
            while (it.hasNext() && !mt) {
                p = it.next();
                f = p.leadingExpVector();
                mt = e.multipleOf(f);
            }
            if (mt) continue;
            F.add(a);
        }
        G = F;
        if (G.size() <= 1) {
            return G;
        }
        Collections.reverse(G);
        MiReducer[] mirs = new MiReducer[G.size()];
        int i = 0;
        F = new ArrayList(G.size());
        while (G.size() > 0) {
            a = G.remove(0);
            ArrayList R = new ArrayList(G.size() + F.size());
            R.addAll(G);
            R.addAll(F);
            mirs[i] = new MiReducer(R, a);
            this.pool.addJob(mirs[i]);
            ++i;
            F.add(a);
        }
        G = F;
        F = new ArrayList(G.size());
        for (i = 0; i < mirs.length; ++i) {
            a = mirs[i].getNF();
            F.add(a);
        }
        return F;
    }
}

