/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBClientSP;
import edu.jas.gb.GroebnerBaseSeqPairDistributed;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.DistThreadPool;
import java.util.List;

public class GBDistSP<C extends RingElem<C>> {
    private final String mfile;
    protected final int threads;
    protected final int port;
    private final GroebnerBaseSeqPairDistributed<C> bbd;
    private final DistThreadPool dtp;

    public GBDistSP(int threads, String mfile, int port) {
        this.threads = threads;
        this.mfile = mfile == null || mfile.length() == 0 ? "../util/machines" : mfile;
        this.port = port;
        this.bbd = new GroebnerBaseSeqPairDistributed(threads, this.port);
        this.dtp = new DistThreadPool(threads, this.mfile);
    }

    public List<GenPolynomial<C>> execute(List<GenPolynomial<C>> F) {
        String master = this.dtp.getEC().getMasterHost();
        int port = this.dtp.getEC().getMasterPort();
        GBClientSP gbc = new GBClientSP(master, port);
        for (int i = 0; i < this.threads; ++i) {
            this.dtp.addJob(gbc);
        }
        List<GenPolynomial<C>> G = this.bbd.GB(F);
        return G;
    }

    public void terminate(boolean shutDown) {
        this.bbd.terminate();
        this.dtp.terminate(shutDown);
    }
}

