/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.RingElem;
import java.util.List;

public class ExtendedGB<C extends RingElem<C>> {
    public final List<GenPolynomial<C>> F;
    public final List<GenPolynomial<C>> G;
    public final List<List<GenPolynomial<C>>> F2G;
    public final List<List<GenPolynomial<C>>> G2F;
    public final GenPolynomialRing<C> ring;

    public ExtendedGB(List<GenPolynomial<C>> F, List<GenPolynomial<C>> G, List<List<GenPolynomial<C>>> F2G, List<List<GenPolynomial<C>>> G2F) {
        this.F = F;
        this.G = G;
        this.F2G = F2G;
        this.G2F = G2F;
        GenPolynomialRing r = null;
        if (G != null) {
            for (GenPolynomial<C> p : G) {
                if (p == null) continue;
                r = p.ring;
                break;
            }
            if (r != null && r.getVars() == null) {
                r.setVars(r.newVars("y"));
            }
        }
        this.ring = r;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("ExtendedGB: \n\n");
        PolynomialList<C> P = new PolynomialList<C>(this.ring, this.F);
        s.append("F = " + P + "\n\n");
        P = new PolynomialList<C>(this.ring, this.G);
        s.append("G = " + P + "\n\n");
        ModuleList<C> M = new ModuleList<C>(this.ring, this.F2G);
        s.append("F2G = " + M + "\n\n");
        M = new ModuleList<C>(this.ring, this.G2F);
        s.append("G2F = " + M + "\n");
        return s.toString();
    }
}

