/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.FDUtil;
import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingElem;
import org.apache.log4j.Logger;

public class GreatestCommonDivisorPrimitive<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    private static final Logger logger = Logger.getLogger(GreatestCommonDivisorPrimitive.class);
    private final boolean debug = true;

    @Override
    public GenSolvablePolynomial<C> baseGcd(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        GenSolvablePolynomial q;
        GenPolynomial r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " no univariate polynomial");
        }
        boolean field = P.ring.coFac.isField();
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        logger.debug((Object)("degrees: e = " + e + ", f = " + f));
        if (field) {
            r = r.monic();
            q = q.monic();
        }
        r = (GenSolvablePolynomial)r.abs();
        q = (GenSolvablePolynomial)q.abs();
        Object a = this.baseContent(r);
        Object b = this.baseContent(q);
        Object c = this.gcd(a, b);
        r = this.divide(r, a);
        q = this.divide(q, b);
        if (r.isONE()) {
            return r.multiply((RingElem)c);
        }
        if (q.isONE()) {
            return q.multiply((RingElem)c);
        }
        while (!r.isZERO()) {
            GenSolvablePolynomial x = FDUtil.baseSparsePseudoRemainder(q, r);
            q = r;
            r = this.basePrimitivePart(x);
            if (!field) continue;
            r = r.monic();
        }
        return (GenSolvablePolynomial)q.multiply((RingElem)c).abs();
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        GenSolvablePolynomial q;
        GenSolvablePolynomial r;
        if (S == null || S.isZERO()) {
            return P;
        }
        if (P == null || P.isZERO()) {
            return S;
        }
        if (P.ring.nvar > 1) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        boolean field = ((GenPolynomial)P.leadingBaseCoefficient()).ring.coFac.isField();
        long e = P.degree(0);
        long f = S.degree(0);
        if (f > e) {
            r = P;
            q = S;
            long g = f;
            f = e;
            e = g;
        } else {
            q = P;
            r = S;
        }
        logger.debug((Object)("degrees: e = " + e + ", f = " + f));
        if (field) {
            r = PolyUtil.monic(r);
            q = PolyUtil.monic(q);
        }
        r = (GenSolvablePolynomial)r.abs();
        q = (GenSolvablePolynomial)q.abs();
        GenSolvablePolynomial a = this.recursiveContent(r);
        GenSolvablePolynomial b = this.recursiveContent(q);
        logger.info((Object)("recCont a = " + a + ", r = " + r));
        logger.info((Object)("recCont b = " + b + ", q = " + q));
        GenSolvablePolynomial c = this.gcd(a, b);
        logger.info((Object)("Gcd(contents) c = " + c));
        r = FDUtil.recursiveDivide(r, a);
        q = FDUtil.recursiveDivide(q, b);
        if (r.isONE()) {
            return r.multiply((RingElem)c);
        }
        if (q.isONE()) {
            return q.multiply((RingElem)c);
        }
        logger.debug((Object)("r.ring = " + r.ring.toScript()));
        while (!r.isZERO()) {
            logger.info((Object)("deg(q) = " + q.degree() + ", deg(r) = " + r.degree()));
            GenSolvablePolynomial x = FDUtil.recursiveSparsePseudoRemainder(q, r);
            q = r;
            r = this.recursivePrimitivePart(x);
            if (!field) continue;
            r = PolyUtil.monic(r);
        }
        logger.info((Object)("gcd(pp) = " + q + ", ring = " + P.ring.toScript()));
        q = (GenSolvablePolynomial)((GenPolynomial)q.abs()).multiply(c);
        return q;
    }
}

