/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.GreatestCommonDivisorPrimitive;
import edu.jas.fd.GreatestCommonDivisorSimple;
import edu.jas.gbmod.SolvableQuotient;
import edu.jas.gbmod.SolvableQuotientRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FDUtil {
    private static final Logger logger = Logger.getLogger(FDUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> baseSparsePseudoRemainder(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        if (P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial<Object> r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GcdRingElem a = (GcdRingElem)r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenSolvablePolynomial<ExpVector> h = S.multiplyLeft(f);
            GcdRingElem c = (GcdRingElem)h.leadingBaseCoefficient();
            GcdRingElem[] oc = fd.leftOreCond(a, c);
            GcdRingElem ga = oc[0];
            GcdRingElem gc = oc[1];
            r = r.multiplyLeft(ga);
            h = h.multiplyLeft((ExpVector)((Object)gc));
            r = (GenSolvablePolynomial)r.subtract((Object)h);
        }
        return r;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C> basePseudoQuotient(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        return FDUtil.basePseudoQuotientRemainder(P, S)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<C>[] basePseudoQuotientRemainder(GenSolvablePolynomial<C> P, GenSolvablePolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[]{null, null};
        if (P.isZERO() || S.isONE()) {
            ret[0] = P;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial<Object> r = P;
        GenSolvablePolynomial q = ((GenSolvablePolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GcdRingElem a = (GcdRingElem)r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenSolvablePolynomial<ExpVector> h = S.multiplyLeft(f);
            GcdRingElem c = (GcdRingElem)h.leadingBaseCoefficient();
            GcdRingElem x = a.remainder(c);
            GcdRingElem[] oc = fd.leftOreCond(a, c);
            GcdRingElem ga = oc[0];
            GcdRingElem gc = oc[1];
            r = r.multiplyLeft(ga);
            h = h.multiplyLeft((ExpVector)((Object)gc));
            q = q.multiplyLeft(ga);
            q = (GenSolvablePolynomial)q.sum((GcdRingElem)gc, f);
            r = (GenSolvablePolynomial)r.subtract((Object)h);
        }
        ret[0] = q;
        ret[1] = r;
        return ret;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveSparsePseudoRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenSolvablePolynomial a = (GenSolvablePolynomial)r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenSolvablePolynomial<AbelianGroupElem<ExpVector>> h = S.multiplyLeft((GenPolynomial<ExpVector>)((Object)f));
            GenSolvablePolynomial d = (GenSolvablePolynomial)h.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] oc = fd.leftOreCond(a, d);
            GenSolvablePolynomial ga = oc[0];
            GenSolvablePolynomial gd = oc[1];
            r = r.multiplyLeft(ga);
            h = h.multiplyLeft(gd);
            if (!((GenPolynomial)r.leadingBaseCoefficient()).equals(h.leadingBaseCoefficient())) {
                throw new RuntimeException("should not happen: lc(r) = " + r.leadingBaseCoefficient() + ", lc(h) = " + h.leadingBaseCoefficient());
            }
            r = (GenSolvablePolynomial)r.subtract(h);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveSparsePseudoRemainderRight(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        ExpVector e = S.leadingExpVector();
        GenPolynomial r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            f = f.subtract(e);
            GenSolvablePolynomial<ExpVector> h = S.multiplyLeft((GenPolynomial<ExpVector>)((Object)f));
            GenPolynomial d = (GenPolynomial)h.leadingBaseCoefficient();
            GenPolynomial a = (GenPolynomial)r.leadingBaseCoefficient();
            r = ((GenSolvablePolynomial)r).multiply((RingElem)d);
            h = h.multiplyLeft((ExpVector)((Object)a));
            if (!((GenPolynomial)r.leadingBaseCoefficient()).equals(h.leadingBaseCoefficient())) {
                throw new RuntimeException("should not happen: lc(r) = " + r.leadingBaseCoefficient() + ", lc(h) = " + h.leadingBaseCoefficient());
            }
            r = (GenSolvablePolynomial)r.subtract(h);
        }
        return r;
    }

    public static <C extends GcdRingElem<C>> boolean isRecursivePseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S, GenSolvablePolynomial<GenPolynomial<C>> q, GenSolvablePolynomial<GenPolynomial<C>> r) {
        GenSolvablePolynomial Rb;
        GenSolvablePolynomial rhs = (GenSolvablePolynomial)q.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)S).sum(r);
        GenSolvablePolynomial lhs = P;
        GenPolynomial ldcf = (GenPolynomial)S.leadingBaseCoefficient();
        long d = P.degree(0) - S.degree(0) + 1L;
        d = d > 0L ? d : -d + 2L;
        for (long i = 0L; i <= d; ++i) {
            if (lhs.equals(rhs)) {
                return true;
            }
            lhs = lhs.multiply((RingElem)ldcf);
        }
        GenPolynomial Pp = P;
        rhs = q.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)S);
        for (long i = 0L; i <= d; ++i) {
            lhs = (GenSolvablePolynomial)Pp.subtract(r);
            if (lhs.equals(rhs)) {
                return true;
            }
            Pp = Pp.multiply((RingElem)ldcf);
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        GenSolvablePolynomial a = (GenSolvablePolynomial)P.leadingBaseCoefficient();
        rhs = (GenSolvablePolynomial)q.multiply((GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<GenSolvablePolynomial<GenPolynomial<C>>>>>>>)S).sum(r);
        GenSolvablePolynomial b = (GenSolvablePolynomial)rhs.leadingBaseCoefficient();
        GenSolvablePolynomial<C>[] oc = fd.leftOreCond(a, b);
        GenSolvablePolynomial ga = oc[0];
        GenSolvablePolynomial gb = oc[1];
        GenSolvablePolynomial Pa = P.multiplyLeft(ga);
        GenSolvablePolynomial D = (GenSolvablePolynomial)Pa.subtract(Rb = rhs.multiplyLeft(gb));
        if (D.isZERO()) {
            return true;
        }
        if (debug) {
            logger.info((Object)("not QR: D = " + D));
        }
        return false;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursivePseudoQuotient(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        return FDUtil.recursivePseudoQuotientRemainder(P, S)[0];
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>>[] recursivePseudoQuotientRemainder(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[2];
        if (P == null || P.isZERO()) {
            ret[0] = S.ring.getZERO();
            ret[1] = S.ring.getZERO();
            return ret;
        }
        if (S.isONE()) {
            ret[0] = P;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        GreatestCommonDivisorSimple fd = new GreatestCommonDivisorSimple();
        ExpVector e = S.leadingExpVector();
        GenSolvablePolynomial r = P;
        GenSolvablePolynomial q = ((GenSolvablePolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            f = f.subtract(e);
            GenSolvablePolynomial<AbelianGroupElem<ExpVector>> h = S.multiplyLeft((GenPolynomial<ExpVector>)((Object)f));
            GenSolvablePolynomial a = (GenSolvablePolynomial)r.leadingBaseCoefficient();
            GenSolvablePolynomial d = (GenSolvablePolynomial)h.leadingBaseCoefficient();
            GenSolvablePolynomial<C>[] oc = fd.leftOreCond(a, d);
            GenSolvablePolynomial ga = oc[0];
            GenSolvablePolynomial gd = oc[1];
            r = r.multiplyLeft(ga);
            h = h.multiplyLeft((AbelianGroupElem<ExpVector>)((ExpVector)((Object)gd)));
            q = q.multiplyLeft(ga);
            q = (GenSolvablePolynomial)q.sum(gd, f);
            r = (GenSolvablePolynomial)r.subtract(h);
        }
        ret[0] = q;
        ret[1] = r;
        return ret;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveDivide(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        GenPolynomial p = ((GenSolvablePolynomial)P.ring.getZERO()).copy();
        for (Map.Entry m1 : P.getMap().entrySet()) {
            GenSolvablePolynomial c1 = (GenSolvablePolynomial)m1.getValue();
            ExpVector e1 = m1.getKey();
            GenSolvablePolynomial<C>[] QR = FDUtil.basePseudoQuotientRemainder(c1, s);
            GenSolvablePolynomial<C> c = QR[0];
            if (!QR[1].isZERO()) {
                System.out.println("rDiv, P  = " + P);
                System.out.println("rDiv, c1 = " + c1);
                System.out.println("rDiv, s  = " + s);
                System.out.println("rDiv, c  = " + c);
                throw new RuntimeException("something is wrong: rem = " + QR[1]);
            }
            if (!c.isZERO()) {
                p.doPutToMap(e1, c);
                continue;
            }
            System.out.println("rDiv, P  = " + P);
            System.out.println("rDiv, c1 = " + c1);
            System.out.println("rDiv, s  = " + s);
            System.out.println("rDiv, c  = " + c);
            throw new RuntimeException("something is wrong: c is zero");
        }
        return p;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> recursiveRightDivide(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        if (!(P instanceof RecSolvablePolynomial)) {
            return FDUtil.recursiveDivide(P, s);
        }
        RecSolvablePolynomialRing rfac = (RecSolvablePolynomialRing)P.ring;
        if (rfac.coeffTable.isEmpty()) {
            return FDUtil.recursiveDivide(P, s);
        }
        GenPolynomialRing cfac = (GenPolynomialRing)rfac.coFac;
        MonoidElem one = cfac.getONE();
        GenSolvablePolynomial onep = rfac.getONE();
        ExpVector zero = rfac.evzero;
        GenSolvablePolynomial q = rfac.getZERO();
        RecSolvablePolynomial p = (RecSolvablePolynomial)P;
        System.out.println("recRightDivide: p = " + p + ", s = " + s);
        while (!p.isZERO()) {
            ExpVector f = p.leadingExpVector();
            GenPolynomial a = (GenPolynomial)p.leadingBaseCoefficient();
            GenSolvablePolynomial c = (GenSolvablePolynomial)a.divide(s);
            if (c.isZERO()) {
                System.out.println("rDiv, P  = " + P);
                System.out.println("rDiv, a  = " + a);
                System.out.println("rDiv, s  = " + s);
                System.out.println("rDiv, c  = " + c);
                throw new RuntimeException("something is wrong: c is zero");
            }
            System.out.println("recRightDivide: a = " + a + ", c = " + c + ", f = " + f);
            RecSolvablePolynomial<C> r = ((RecSolvablePolynomial)onep).multiply(c, f, s, zero);
            System.out.println("content r   = " + r);
            p = (RecSolvablePolynomial)p.subtract(r);
            q = (RecSolvablePolynomial)q.sum(c, f);
        }
        return q;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> rightRecursivePolynomial(GenSolvablePolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        if (!(P instanceof RecSolvablePolynomial)) {
            return P;
        }
        RecSolvablePolynomialRing rfac = (RecSolvablePolynomialRing)P.ring;
        if (rfac.coeffTable.isEmpty()) {
            return P;
        }
        GenPolynomialRing cfac = (GenPolynomialRing)rfac.coFac;
        MonoidElem one = cfac.getONE();
        GenSolvablePolynomial onep = rfac.getONE();
        ExpVector zero = rfac.evzero;
        GenSolvablePolynomial R = rfac.getZERO();
        RecSolvablePolynomial p = (RecSolvablePolynomial)P;
        while (!p.isZERO()) {
            ExpVector f = p.leadingExpVector();
            GenPolynomial a = (GenPolynomial)p.leadingBaseCoefficient();
            RecSolvablePolynomial r = ((RecSolvablePolynomial)onep).multiply(one, f, a, zero);
            p = (RecSolvablePolynomial)p.subtract(r);
            R = (RecSolvablePolynomial)R.sum(a, f);
        }
        return R;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> evalAsRightRecursivePolynomial(GenSolvablePolynomial<GenPolynomial<C>> R) {
        if (R == null || R.isZERO()) {
            return R;
        }
        if (!(R instanceof RecSolvablePolynomial)) {
            return R;
        }
        RecSolvablePolynomialRing rfac = (RecSolvablePolynomialRing)R.ring;
        if (rfac.coeffTable.isEmpty()) {
            return R;
        }
        GenPolynomialRing cfac = (GenPolynomialRing)rfac.coFac;
        MonoidElem one = cfac.getONE();
        GenSolvablePolynomial onep = rfac.getONE();
        ExpVector zero = rfac.evzero;
        GenSolvablePolynomial q = rfac.getZERO();
        RecSolvablePolynomial r = (RecSolvablePolynomial)R;
        for (Map.Entry y : r.getMap().entrySet()) {
            ExpVector f = y.getKey();
            GenPolynomial a = (GenPolynomial)y.getValue();
            RecSolvablePolynomial s = ((RecSolvablePolynomial)onep).multiply(one, f, a, zero);
            q = (RecSolvablePolynomial)q.sum(s);
        }
        return q;
    }

    public static <C extends RingElem<C>> boolean isRightRecursivePolynomial(GenSolvablePolynomial<GenPolynomial<C>> P, GenSolvablePolynomial<GenPolynomial<C>> R) {
        if (P == null) {
            return R == null;
        }
        if (P.isZERO()) {
            return R.isZERO();
        }
        if (!(P instanceof RecSolvablePolynomial)) {
            return !(R instanceof RecSolvablePolynomial);
        }
        RecSolvablePolynomialRing rfac = (RecSolvablePolynomialRing)P.ring;
        if (rfac.coeffTable.isEmpty()) {
            RecSolvablePolynomialRing rf = (RecSolvablePolynomialRing)R.ring;
            return rf.coeffTable.isEmpty();
        }
        RecSolvablePolynomial p = (RecSolvablePolynomial)P;
        RecSolvablePolynomial q = (RecSolvablePolynomial)FDUtil.evalAsRightRecursivePolynomial(R);
        p = (RecSolvablePolynomial)PolyUtil.monic(p);
        q = (RecSolvablePolynomial)PolyUtil.monic(q);
        return p.equals(q);
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> integralFromQuotientCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> fac, GenSolvablePolynomial<SolvableQuotient<C>> A) {
        GenPolynomial B = ((GenSolvablePolynomial)fac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        GenSolvablePolynomial<Object> c = null;
        GreatestCommonDivisorPrimitive fd = new GreatestCommonDivisorPrimitive();
        int s = 0;
        for (SolvableQuotient solvableQuotient : A.getMap().values()) {
            GenSolvablePolynomial x = solvableQuotient.den;
            if (c == null) {
                c = x;
                s = x.signum();
                continue;
            }
            GenSolvablePolynomial d = fd.gcd(c, x);
            GenSolvablePolynomial z = (GenSolvablePolynomial)x.divide(d);
            c = z.multiply(c);
        }
        if (s < 0) {
            c = (GenSolvablePolynomial)c.negate();
        }
        for (Map.Entry entry : A.getMap().entrySet()) {
            ExpVector e = (ExpVector)entry.getKey();
            SolvableQuotient a = (SolvableQuotient)entry.getValue();
            GenPolynomial b = c.divide(a.den);
            GenPolynomial p = ((GenPolynomial)a.num).multiply(b);
            B.doPutToMap(e, p);
        }
        return B;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<GenPolynomial<C>>> integralFromQuotientCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> fac, Collection<GenSolvablePolynomial<SolvableQuotient<C>>> L) {
        if (L == null) {
            return null;
        }
        ArrayList<GenSolvablePolynomial<GenPolynomial<C>>> list = new ArrayList<GenSolvablePolynomial<GenPolynomial<C>>>(L.size());
        for (GenSolvablePolynomial<SolvableQuotient<C>> p : L) {
            list.add(FDUtil.integralFromQuotientCoefficients(fac, p));
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenSolvablePolynomial<SolvableQuotient<C>> quotientFromIntegralCoefficients(GenSolvablePolynomialRing<SolvableQuotient<C>> fac, GenSolvablePolynomial<GenPolynomial<C>> A) {
        GenPolynomial B = ((GenSolvablePolynomial)fac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return B;
        }
        RingFactory cfac = fac.coFac;
        SolvableQuotientRing qfac = (SolvableQuotientRing)cfac;
        for (Map.Entry y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenSolvablePolynomial a = (GenSolvablePolynomial)y.getValue();
            SolvableQuotient p = new SolvableQuotient(qfac, a);
            if (p.isZERO()) continue;
            B.doPutToMap(e, p);
        }
        return B;
    }

    public static <C extends GcdRingElem<C>> List<GenSolvablePolynomial<SolvableQuotient<C>>> quotientFromIntegralCoefficients(GenSolvablePolynomialRing<SolvableQuotient<C>> fac, Collection<GenSolvablePolynomial<GenPolynomial<C>>> L) {
        if (L == null) {
            return null;
        }
        ArrayList<GenSolvablePolynomial<SolvableQuotient<C>>> list = new ArrayList<GenSolvablePolynomial<SolvableQuotient<C>>>(L.size());
        for (GenSolvablePolynomial<GenPolynomial<C>> p : L) {
            list.add(FDUtil.quotientFromIntegralCoefficients(fac, p));
        }
        return list;
    }
}

