/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocal;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class SolvableLocalRing<C extends GcdRingElem<C>>
implements RingFactory<SolvableLocal<C>>,
QuotPairFactory<GenPolynomial<C>, SolvableLocal<C>> {
    private static final Logger logger = Logger.getLogger(SolvableLocalRing.class);
    private final boolean debug = logger.isDebugEnabled();
    public final SolvableIdeal<C> ideal;
    public final GenSolvablePolynomialRing<C> ring;
    public final SolvableSyzygyAbstract<C> engine;
    protected final SolvableGroebnerBaseAbstract<C> bb;
    protected int isField = -1;

    public SolvableLocalRing(SolvableIdeal<C> i) {
        if (i == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ring = i.getRing();
        this.ideal = i.GB();
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
        } else {
            this.isField = 0;
            logger.warn((Object)"ideal not maximal");
        }
        this.engine = new SolvableSyzygyAbstract();
        this.bb = new SolvableGroebnerBaseSeq();
        logger.debug((Object)"solvable local ring constructed");
    }

    @Override
    public GenSolvablePolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public SolvableLocal<C> create(GenPolynomial<C> n) {
        return new SolvableLocal(this, (GenSolvablePolynomial)n);
    }

    @Override
    public SolvableLocal<C> create(GenPolynomial<C> n, GenPolynomial<C> d) {
        return new SolvableLocal(this, (GenSolvablePolynomial)n, (GenSolvablePolynomial)d);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite() && this.bb.commonZeroTest(this.ideal.getList()) <= 0;
    }

    @Override
    public SolvableLocal<C> copy(SolvableLocal<C> c) {
        return new SolvableLocal(c.ring, c.num, c.den, true);
    }

    @Override
    public SolvableLocal<C> getZERO() {
        return new SolvableLocal(this, this.ring.getZERO());
    }

    @Override
    public SolvableLocal<C> getONE() {
        return new SolvableLocal(this, this.ring.getONE());
    }

    @Override
    public List<SolvableLocal<C>> generators() {
        List pgens = PolynomialList.castToSolvableList(this.ring.generators());
        ArrayList<SolvableLocal<C>> gens = new ArrayList<SolvableLocal<C>>(pgens.size() * 2 - 1);
        GenPolynomial one = this.ring.getONE();
        for (GenSolvablePolynomial p : pgens) {
            SolvableLocal q = new SolvableLocal(this, p);
            gens.add(q);
            if (p.isONE() || this.ideal.contains(p)) continue;
            q = new SolvableLocal(this, one, p);
            gens.add(q);
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        if (!this.ring.isAssociative()) {
            return false;
        }
        List<SolvableLocal<C>> gens = this.generators();
        int ngen = gens.size();
        for (int i = 0; i < ngen; ++i) {
            SolvableLocal<C> Xi = gens.get(i);
            for (int j = i + 1; j < ngen; ++j) {
                SolvableLocal<SolvableLocal<C>> Xj = gens.get(j);
                for (int k = j + 1; k < ngen; ++k) {
                    SolvableLocal<SolvableLocal<SolvableLocal<C>>> q;
                    SolvableLocal<SolvableLocal<C>> p;
                    SolvableLocal<SolvableLocal<SolvableLocal<C>>> Xk = gens.get(k);
                    try {
                        p = Xk.multiply(Xj).multiply((SolvableLocal<SolvableLocal<C>>)Xi);
                        q = Xk.multiply(Xj.multiply(Xi));
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    if (p.equals(q)) continue;
                    logger.info((Object)("Xk = " + Xk + ", Xj = " + Xj + ", Xi = " + Xi));
                    logger.info((Object)("p = ( Xk * Xj ) * Xi = " + p));
                    logger.info((Object)("q = Xk * ( Xj * Xi ) = " + q));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public SolvableLocal<C> fromInteger(BigInteger a) {
        return new SolvableLocal(this, this.ring.fromInteger(a));
    }

    @Override
    public SolvableLocal<C> fromInteger(long a) {
        return new SolvableLocal(this, this.ring.fromInteger(a));
    }

    public String toString() {
        return "SolvableLocalRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "SLC(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof SolvableLocalRing)) {
            return false;
        }
        SolvableLocalRing a = null;
        try {
            a = (SolvableLocalRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.ideal.equals(a.ideal);
    }

    public int hashCode() {
        int h = this.ideal.hashCode();
        return h;
    }

    @Override
    public SolvableLocal<C> random(int n) {
        GenSolvablePolynomial<C> s;
        GenSolvablePolynomial<C> r = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        r = this.ideal.normalform(r);
        do {
            s = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new SolvableLocal<C>(this, r, s, false);
    }

    public SolvableLocal<C> random(int k, int l, int d, float q) {
        GenSolvablePolynomial<C> s;
        GenSolvablePolynomial<C> r = ((GenSolvablePolynomial)this.ring.random(k, l, d, q)).monic();
        r = this.ideal.normalform(r);
        do {
            s = ((GenSolvablePolynomial)this.ring.random(k, l, d, q)).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new SolvableLocal<C>(this, r, s, false);
    }

    @Override
    public SolvableLocal<C> random(int n, Random rnd) {
        GenSolvablePolynomial<C> s;
        GenSolvablePolynomial<C> r = ((GenSolvablePolynomial)this.ring.random(n, rnd)).monic();
        r = this.ideal.normalform(r);
        do {
            s = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new SolvableLocal<C>(this, r, s, false);
    }

    @Override
    public SolvableLocal<C> parse(String s) {
        int i = s.indexOf("{");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        if ((i = s.lastIndexOf("}")) >= 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("|")) < 0) {
            GenPolynomial n = this.ring.parse(s);
            return new SolvableLocal(this, n);
        }
        String s1 = s.substring(0, i);
        String s2 = s.substring(i + 1);
        GenPolynomial n = this.ring.parse(s1);
        GenPolynomial d = this.ring.parse(s2);
        return new SolvableLocal(this, n, d);
    }

    @Override
    public SolvableLocal<C> parse(Reader r) {
        String s = StringUtil.nextPairedString(r, '{', '}');
        return this.parse(s);
    }
}

