/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocalResidue;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbmod.SolvableSyzygyAbstract;
import edu.jas.kern.StringUtil;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPairFactory;
import edu.jas.structure.RingFactory;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class SolvableLocalResidueRing<C extends GcdRingElem<C>>
implements RingFactory<SolvableLocalResidue<C>>,
QuotPairFactory<GenPolynomial<C>, SolvableLocalResidue<C>> {
    private static final Logger logger = Logger.getLogger(SolvableLocalResidueRing.class);
    private final boolean debug = logger.isDebugEnabled();
    public final GenSolvablePolynomialRing<C> ring;
    public final SolvableIdeal<C> ideal;
    public final SolvableSyzygyAbstract<C> engine;
    protected final SolvableGroebnerBaseAbstract<C> bb;
    protected int isField = -1;

    public SolvableLocalResidueRing(SolvableIdeal<C> i) {
        if (i == null) {
            throw new IllegalArgumentException("ideal may not be null");
        }
        this.ring = i.getRing();
        this.ideal = i.GB();
        if (this.ideal.isONE()) {
            throw new IllegalArgumentException("ideal may not be 1");
        }
        if (this.ideal.isMaximal()) {
            this.isField = 1;
        } else {
            logger.warn((Object)"ideal not maximal and not known to be prime");
        }
        this.engine = new SolvableSyzygyAbstract();
        this.bb = new SolvableGroebnerBaseSeq();
        logger.debug((Object)"solvable local residue ring constructed");
    }

    @Override
    public GenSolvablePolynomialRing<C> pairFactory() {
        return this.ring;
    }

    @Override
    public SolvableLocalResidue<C> create(GenPolynomial<C> n) {
        return new SolvableLocalResidue(this, (GenSolvablePolynomial)n);
    }

    @Override
    public SolvableLocalResidue<C> create(GenPolynomial<C> n, GenPolynomial<C> d) {
        return new SolvableLocalResidue(this, (GenSolvablePolynomial)n, (GenSolvablePolynomial)d);
    }

    @Override
    public boolean isFinite() {
        return this.ring.isFinite() && this.bb.commonZeroTest(this.ideal.getList()) <= 0;
    }

    @Override
    public SolvableLocalResidue<C> copy(SolvableLocalResidue<C> c) {
        return new SolvableLocalResidue(c.ring, c.num, c.den, true);
    }

    @Override
    public SolvableLocalResidue<C> getZERO() {
        return new SolvableLocalResidue(this, this.ring.getZERO());
    }

    @Override
    public SolvableLocalResidue<C> getONE() {
        return new SolvableLocalResidue(this, this.ring.getONE());
    }

    @Override
    public List<SolvableLocalResidue<C>> generators() {
        List pgens = PolynomialList.castToSolvableList(this.ring.generators());
        ArrayList<SolvableLocalResidue<C>> gens = new ArrayList<SolvableLocalResidue<C>>(pgens.size() * 2 - 1);
        GenPolynomial one = this.ring.getONE();
        for (GenSolvablePolynomial p : pgens) {
            SolvableLocalResidue q = new SolvableLocalResidue(this, p);
            if (q.isZERO()) continue;
            gens.add(q);
            if (p.isONE() || this.ideal.contains(p)) continue;
            q = new SolvableLocalResidue(this, one, p);
            gens.add(q);
        }
        return gens;
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    @Override
    public boolean isAssociative() {
        if (!this.ring.isAssociative()) {
            return false;
        }
        List<SolvableLocalResidue<C>> gens = this.generators();
        int ngen = gens.size();
        for (int i = 0; i < ngen; ++i) {
            SolvableLocalResidue<C> Xi = gens.get(i);
            for (int j = i + 1; j < ngen; ++j) {
                SolvableLocalResidue<SolvableLocalResidue<C>> Xj = gens.get(j);
                for (int k = j + 1; k < ngen; ++k) {
                    SolvableLocalResidue<SolvableLocalResidue<SolvableLocalResidue<C>>> q;
                    SolvableLocalResidue<SolvableLocalResidue<C>> p;
                    SolvableLocalResidue<SolvableLocalResidue<SolvableLocalResidue<C>>> Xk = gens.get(k);
                    try {
                        p = Xk.multiply(Xj).multiply((SolvableLocalResidue<SolvableLocalResidue<C>>)Xi);
                        q = Xk.multiply(Xj.multiply(Xi));
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    if (p.equals(q)) continue;
                    logger.info((Object)("Xk = " + Xk + ", Xj = " + Xj + ", Xi = " + Xi));
                    logger.info((Object)("p = ( Xk * Xj ) * Xi = " + p));
                    logger.info((Object)("q = Xk * ( Xj * Xi ) = " + q));
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isField() {
        if (this.isField > 0) {
            return true;
        }
        if (this.isField == 0) {
            return false;
        }
        return false;
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public SolvableLocalResidue<C> fromInteger(BigInteger a) {
        return new SolvableLocalResidue(this, this.ring.fromInteger(a));
    }

    @Override
    public SolvableLocalResidue<C> fromInteger(long a) {
        return new SolvableLocalResidue(this, this.ring.fromInteger(a));
    }

    public String toString() {
        return "SolvableLocalResidueRing[ " + this.ideal.toString() + " ]";
    }

    @Override
    public String toScript() {
        return "SLR(" + this.ideal.list.toScript() + ")";
    }

    public boolean equals(Object b) {
        if (!(b instanceof SolvableLocalResidueRing)) {
            return false;
        }
        SolvableLocalResidueRing a = null;
        try {
            a = (SolvableLocalResidueRing)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        return this.ring.equals(a.ring);
    }

    public int hashCode() {
        int h = this.ideal.hashCode();
        return h;
    }

    @Override
    public SolvableLocalResidue<C> random(int n) {
        GenSolvablePolynomial<C> s;
        GenSolvablePolynomial<C> r = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        r = this.ideal.normalform(r);
        do {
            s = ((GenSolvablePolynomial)this.ring.random(n)).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new SolvableLocalResidue<C>(this, r, s, false);
    }

    public SolvableLocalResidue<C> random(int k, int l, int d, float q) {
        GenSolvablePolynomial<C> s;
        GenSolvablePolynomial<C> r = ((GenSolvablePolynomial)this.ring.random(k, l, d, q)).monic();
        r = this.ideal.normalform(r);
        do {
            s = ((GenSolvablePolynomial)this.ring.random(k, l, d, q)).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new SolvableLocalResidue<C>(this, r, s, false);
    }

    @Override
    public SolvableLocalResidue<C> random(int n, Random rnd) {
        GenSolvablePolynomial<C> s;
        GenSolvablePolynomial<C> r = ((GenSolvablePolynomial)this.ring.random(n, rnd)).monic();
        r = this.ideal.normalform(r);
        do {
            s = ((GenSolvablePolynomial)this.ring.random(n, rnd)).monic();
        } while ((s = this.ideal.normalform(s)).isZERO());
        return new SolvableLocalResidue<C>(this, r, s, false);
    }

    @Override
    public SolvableLocalResidue<C> parse(String s) {
        int i = s.indexOf("{");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        if ((i = s.lastIndexOf("}")) >= 0) {
            s = s.substring(0, i);
        }
        if ((i = s.indexOf("|")) < 0) {
            GenPolynomial n = this.ring.parse(s);
            return new SolvableLocalResidue(this, n);
        }
        String s1 = s.substring(0, i);
        String s2 = s.substring(i + 1);
        GenPolynomial n = this.ring.parse(s1);
        GenPolynomial d = this.ring.parse(s2);
        return new SolvableLocalResidue(this, n, d);
    }

    @Override
    public SolvableLocalResidue<C> parse(Reader r) {
        String s = StringUtil.nextPairedString(r, '{', '}');
        return this.parse(s);
    }
}

