/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.RingFactoryTokenizer;
import edu.jas.application.RunGB;
import edu.jas.gb.SolvableGroebnerBaseParallel;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gb.SolvableGroebnerBaseSeqPairParallel;
import edu.jas.gb.SolvableReductionPar;
import edu.jas.gb.SolvableReductionSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.util.CatReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.BasicConfigurator;

public class RunSGB {
    static boolean doCheck = false;
    static boolean doLog = true;

    public static void main(String[] args) {
        Reader problem;
        int j;
        String[] allkinds = new String[]{"seq", "seq+", "par", "par+"};
        String[] allmeth = new String[]{"irr", "left", "right", "two"};
        String usage = "Usage: RunGB [ " + RunSGB.join(allkinds, " | ") + " ] [" + RunSGB.join(allmeth, " | ") + "] <file> " + "#threads " + "[check] [nolog]";
        if (args.length < 3) {
            System.out.println("args: " + Arrays.toString(args));
            System.out.println(usage);
            return;
        }
        boolean plusextra = false;
        String kind = args[0];
        boolean sup = false;
        int k = -1;
        for (int i = 0; i < args.length; ++i) {
            j = RunSGB.indexOf(allkinds, args[i]);
            if (j < 0) continue;
            sup = true;
            k = i;
            kind = args[k];
            break;
        }
        if (!sup) {
            System.out.println("args(sup): " + Arrays.toString(args));
            System.out.println(usage);
            return;
        }
        if (kind.indexOf("+") >= 0) {
            plusextra = true;
        }
        System.out.println("kind: " + kind + ", k = " + k);
        String action = args[k + 1];
        sup = false;
        j = RunSGB.indexOf(allmeth, action);
        if (j < 0) {
            System.out.println(usage);
            return;
        }
        String filename = args[k + 2];
        int threads = 0;
        if (kind.startsWith("par")) {
            String tup;
            if (args.length < 4) {
                System.out.println("args(par): " + Arrays.toString(args));
                System.out.println(usage);
                return;
            }
            String t = tup = args[k + 3];
            try {
                threads = Integer.parseInt(t);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                System.out.println("args(threads): " + Arrays.toString(args));
                System.out.println(usage);
                return;
            }
            if (threads < 1) {
                threads = 1;
            }
        }
        if ((j = RunSGB.indexOf(args, "check")) >= 0) {
            doCheck = true;
        }
        if ((j = RunSGB.indexOf(args, "nolog")) >= 0) {
            doLog = false;
        }
        if ((problem = RunGB.getReader(filename)) == null) {
            System.out.println("args(file): " + filename);
            System.out.println("args(file): examples.jar(" + filename + ")");
            System.out.println("args(file): " + Arrays.toString(args));
            System.out.println(usage);
            return;
        }
        RingFactoryTokenizer rftok = new RingFactoryTokenizer(problem);
        GenSolvablePolynomialRing spfac = null;
        try {
            spfac = rftok.nextSolvablePolynomialRing();
            rftok = null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        CatReader polyreader = new CatReader(new StringReader("("), problem);
        GenPolynomialTokenizer tok = new GenPolynomialTokenizer(spfac, polyreader);
        PolynomialList S = null;
        try {
            S = new PolynomialList(spfac, tok.nextSolvablePolynomialList());
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.out.println("S =\n" + S);
        if (doLog) {
            BasicConfigurator.configure();
        }
        if (kind.startsWith("seq")) {
            RunSGB.runSequential(S, action, plusextra);
        } else if (kind.startsWith("par")) {
            RunSGB.runParallel(S, threads, action, plusextra);
        }
        ComputerThreads.terminate();
    }

    static void runSequential(PolynomialList S, String action, boolean plusextra) {
        List L = S.list;
        List G = null;
        SolvableReductionSeq sred = new SolvableReductionSeq();
        SolvableGroebnerBaseSeq sbb = null;
        sbb = plusextra ? new SolvableGroebnerBaseSeq() : new SolvableGroebnerBaseSeq();
        long t = System.currentTimeMillis();
        System.out.println("\nSolvable GB [" + action + "] sequential ...");
        if (action.equals("irr")) {
            G = sred.leftIrreducibleSet(L);
        }
        if (action.equals("left")) {
            G = sbb.leftGB(L);
        }
        if (action.equals("right")) {
            G = sbb.rightGB(L);
        }
        if (action.equals("two")) {
            G = sbb.twosidedGB(L);
        }
        if (G == null) {
            System.out.println("unknown action = " + action + "\n");
            return;
        }
        S = new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (plusextra) {
            System.out.print("seq+, ");
        } else {
            System.out.print("seq, ");
        }
        System.out.println("time = " + t + " milliseconds");
        RunSGB.checkGB(S);
        System.out.println("");
    }

    static void runParallel(PolynomialList S, int threads, String action, boolean plusextra) {
        List L = S.list;
        List G = null;
        SolvableReductionPar sred = new SolvableReductionPar();
        SolvableGroebnerBaseParallel sbb = null;
        SolvableGroebnerBaseSeqPairParallel sbbs = null;
        if (plusextra) {
            sbbs = new SolvableGroebnerBaseSeqPairParallel(threads);
        } else {
            sbb = new SolvableGroebnerBaseParallel(threads);
        }
        long t = System.currentTimeMillis();
        System.out.println("\nSolvable GB [" + action + "] parallel " + threads + " threads ...");
        if (action.equals("irr")) {
            G = sred.leftIrreducibleSet(L);
        }
        if (action.equals("left")) {
            G = plusextra ? sbbs.leftGB(L) : sbb.leftGB(L);
        }
        if (action.equals("right")) {
            G = plusextra ? sbbs.rightGB(L) : sbb.rightGB(L);
        }
        if (action.equals("two")) {
            G = plusextra ? sbbs.twosidedGB(L) : sbb.twosidedGB(L);
        }
        if (G == null) {
            System.out.println("unknown action = " + action + "\n");
            return;
        }
        S = G.size() > 0 ? new PolynomialList(G.get((int)0).ring, G) : new PolynomialList(S.ring, G);
        System.out.println("G =\n" + S);
        System.out.println("G.size() = " + G.size());
        t = System.currentTimeMillis() - t;
        if (plusextra) {
            System.out.print("p+ ");
        } else {
            System.out.print("p ");
        }
        System.out.println("= " + threads + ", time = " + t + " milliseconds");
        RunSGB.checkGB(S);
        System.out.println("");
        if (plusextra) {
            sbbs.terminate();
        } else {
            sbb.terminate();
        }
    }

    static void checkGB(PolynomialList S) {
        if (!doCheck) {
            return;
        }
        SolvableGroebnerBaseSeq sbb = new SolvableGroebnerBaseSeq();
        long t = System.currentTimeMillis();
        boolean chk = sbb.isLeftGB(S.list, false);
        t = System.currentTimeMillis() - t;
        System.out.println("check isGB = " + chk + " in " + t + " milliseconds");
    }

    static int indexOf(String[] args, String s) {
        for (int i = 0; i < args.length; ++i) {
            if (!s.equals(args[i])) continue;
            return i;
        }
        return -1;
    }

    static String join(String[] args, String d) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }
}

