/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.Rational;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;

public class RealAlgebraicNumber<C extends GcdRingElem<C> & Rational>
implements GcdRingElem<RealAlgebraicNumber<C>>,
Rational {
    public final edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>> number;
    public final RealAlgebraicRing<C> ring;

    public RealAlgebraicNumber(RealAlgebraicRing<C> r) {
        this(r, (edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>)r.realRing.getZERO());
    }

    public RealAlgebraicNumber(RealAlgebraicRing<C> r, C a) {
        this(r, (edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>)r.realRing.parse(a.toString()));
    }

    public RealAlgebraicNumber(RealAlgebraicRing<C> r, GenPolynomial<C> a) {
        this(r, (edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>)r.realRing.parse(a.toString()));
    }

    public RealAlgebraicNumber(RealAlgebraicRing<C> r, edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>> a) {
        this.number = a;
        this.ring = r;
    }

    @Override
    public RealAlgebraicRing<C> factory() {
        return this.ring;
    }

    @Override
    public RealAlgebraicNumber<C> copy() {
        return new RealAlgebraicNumber<C>(this.ring, this.number);
    }

    @Override
    public BigRational getRational() {
        return this.magnitude();
    }

    @Override
    public boolean isZERO() {
        return this.number.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.number.isONE();
    }

    @Override
    public boolean isUnit() {
        return this.number.isUnit();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            return "{ " + this.number.toString() + " }";
        }
        return "Complex" + this.number.toString();
    }

    @Override
    public String toScript() {
        return this.number.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((RealAlgebraicRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(RealAlgebraicNumber<C> b) {
        int s = 0;
        if (this.number.ring != b.number.ring) {
            s = this.number.ring.equals(b.number.ring) ? 0 : 1;
            System.out.println("s_mod = " + s);
        }
        if (s != 0) {
            return s;
        }
        s = this.number.compareTo((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)b.number);
        return s;
    }

    @Override
    public int compareTo(edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>> b) {
        int s = this.number.compareTo((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)b);
        return s;
    }

    @Override
    public boolean equals(Object b) {
        if (!(b instanceof RealAlgebraicNumber)) {
            return false;
        }
        RealAlgebraicNumber a = null;
        try {
            a = (RealAlgebraicNumber)b;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (a == null) {
            return false;
        }
        if (!this.ring.equals(a.ring)) {
            return false;
        }
        return this.number.equals(a.number);
    }

    @Override
    public int hashCode() {
        return 37 * this.number.hashCode() + this.ring.hashCode();
    }

    @Override
    public RealAlgebraicNumber<C> abs() {
        if (this.signum() < 0) {
            return new RealAlgebraicNumber<C>(this.ring, this.number.negate());
        }
        return this;
    }

    @Override
    public RealAlgebraicNumber<C> sum(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.sum((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)S.number));
    }

    @Override
    public RealAlgebraicNumber<C> sum(edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>> c) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.sum((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)c));
    }

    @Override
    public RealAlgebraicNumber<C> negate() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.negate());
    }

    @Override
    public RealAlgebraicNumber<C> subtract(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.subtract((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)S.number));
    }

    @Override
    public RealAlgebraicNumber<C> divide(RealAlgebraicNumber<C> S) {
        return this.multiply((RealAlgebraicNumber<C>)S.inverse());
    }

    @Override
    public RealAlgebraicNumber<C> inverse() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.inverse());
    }

    @Override
    public RealAlgebraicNumber<C> remainder(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.remainder((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)S.number));
    }

    @Override
    public RealAlgebraicNumber<C> multiply(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.multiply((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)S.number));
    }

    @Override
    public RealAlgebraicNumber<C> multiply(edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>> c) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.multiply((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)c));
    }

    public RealAlgebraicNumber<C> monic() {
        return new RealAlgebraicNumber<C>(this.ring, this.number.monic());
    }

    @Override
    public RealAlgebraicNumber<C> gcd(RealAlgebraicNumber<C> S) {
        return new RealAlgebraicNumber<C>(this.ring, this.number.gcd((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)S.number));
    }

    public RealAlgebraicNumber<C>[] egcd(RealAlgebraicNumber<C> S) {
        edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>[] aret = this.number.egcd((edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<edu.jas.root.RealAlgebraicNumber<C>>>)S.number);
        RealAlgebraicNumber[] ret = new RealAlgebraicNumber[]{new RealAlgebraicNumber<C>(this.ring, aret[0]), new RealAlgebraicNumber<C>(this.ring, aret[1]), new RealAlgebraicNumber<C>(this.ring, aret[2])};
        return ret;
    }

    @Override
    public int signum() {
        return this.number.signum();
    }

    public BigRational magnitude() {
        return this.number.magnitude();
    }

    public BigDecimal decimalMagnitude() {
        BigRational cr = this.magnitude();
        return new BigDecimal(cr);
    }
}

