/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.List;

public class IdealWithComplexAlgebraicRoots<D extends GcdRingElem<D> & Rational>
extends IdealWithUniv<D> {
    public final List<List<Complex<RealAlgebraicNumber<D>>>> can;
    protected List<List<Complex<BigDecimal>>> droots = null;

    protected IdealWithComplexAlgebraicRoots() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public IdealWithComplexAlgebraicRoots(Ideal<D> id, List<GenPolynomial<D>> up, List<List<Complex<RealAlgebraicNumber<D>>>> cr) {
        super(id, up);
        this.can = cr;
    }

    public IdealWithComplexAlgebraicRoots(IdealWithUniv<D> iu, List<List<Complex<RealAlgebraicNumber<D>>>> cr) {
        super(iu.ideal, iu.upolys);
        this.can = cr;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString() + "\ncomplex roots:\n");
        sb.append("[");
        boolean f1 = true;
        for (List<Complex<RealAlgebraicNumber<D>>> list : this.can) {
            if (!f1) {
                sb.append(", ");
            } else {
                f1 = false;
            }
            sb.append("[");
            boolean f2 = true;
            for (Complex<RealAlgebraicNumber<D>> rr : list) {
                if (!f2) {
                    sb.append(", ");
                } else {
                    f2 = false;
                }
                sb.append(rr.ring.toScript());
            }
            sb.append("]");
        }
        sb.append("]");
        if (this.droots != null) {
            sb.append("\ndecimal complex root approximation:\n");
            for (List<Complex<GcdRingElem<RealAlgebraicNumber<Object>>>> list : this.droots) {
                sb.append(list.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String toScript() {
        return super.toScript() + ",  " + this.can.toString();
    }

    public synchronized List<List<Complex<BigDecimal>>> decimalApproximation() {
        if (this.droots != null) {
            return this.droots;
        }
        ArrayList<List<Complex<BigDecimal>>> rroots = new ArrayList<List<Complex<BigDecimal>>>();
        ComplexRing<BigDecimal> cfac = new ComplexRing<BigDecimal>(new BigDecimal());
        for (List<Complex<RealAlgebraicNumber<D>>> rri : this.can) {
            ArrayList<Complex<BigDecimal>> r = new ArrayList<Complex<BigDecimal>>();
            for (Complex<RealAlgebraicNumber<D>> rr : rri) {
                BigDecimal dr = new BigDecimal(rr.getRe().magnitude());
                BigDecimal di = new BigDecimal(rr.getIm().magnitude());
                Complex<BigDecimal> d = new Complex<BigDecimal>(cfac, dr, di);
                r.add(d);
            }
            rroots.add(r);
        }
        this.droots = rroots;
        return rroots;
    }

    public void doDecimalApproximation() {
        List<List<Complex<BigDecimal>>> unused = this.decimalApproximation();
        if (unused.isEmpty()) {
            System.out.println("unused is empty");
        }
    }
}

