/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.ResidueRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexAlgebraicRing;
import edu.jas.root.Interval;
import edu.jas.root.RealAlgebraicRing;
import edu.jas.root.Rectangle;
import edu.jas.root.RootUtil;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.QuotientRing;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;

public class ExtensionFieldBuilder
implements Serializable {
    public final RingFactory factory;

    protected ExtensionFieldBuilder() {
        throw new IllegalArgumentException("do not use this constructor");
    }

    public ExtensionFieldBuilder(RingFactory base) {
        this.factory = base;
    }

    public RingFactory build() {
        return this.factory;
    }

    public static ExtensionFieldBuilder baseField(RingFactory base) {
        return new ExtensionFieldBuilder(base);
    }

    public ExtensionFieldBuilder transcendentExtension(String vars) {
        QuotientRing qfac;
        String[] variables = GenPolynomialTokenizer.variableList(vars);
        GenPolynomialRing pfac = new GenPolynomialRing(this.factory, variables);
        QuotientRing base = qfac = new QuotientRing(pfac);
        return new ExtensionFieldBuilder(base);
    }

    public ExtensionFieldBuilder polynomialExtension(String vars) {
        GenPolynomialRing pfac;
        String[] variables = GenPolynomialTokenizer.variableList(vars);
        GenPolynomialRing base = pfac = new GenPolynomialRing(this.factory, variables);
        return new ExtensionFieldBuilder(base);
    }

    public ExtensionFieldBuilder algebraicExtension(String var, String expr) {
        ResidueRing afac;
        String[] variables = GenPolynomialTokenizer.variableList(var);
        if (variables.length < 1 && (variables = GenPolynomialTokenizer.expressionVariables(expr)).length < 1) {
            throw new IllegalArgumentException("no variables in '" + var + "' and '" + expr + "'");
        }
        GenPolynomialRing pfac = new GenPolynomialRing(this.factory, variables);
        if (variables.length == 1) {
            AlgebraicNumberRing afac2;
            Element gen = pfac.parse(expr);
            AlgebraicNumberRing base = afac2 = new AlgebraicNumberRing(gen);
            return new ExtensionFieldBuilder(base);
        }
        GenPolynomialTokenizer pt = new GenPolynomialTokenizer(pfac, new StringReader(expr));
        List gen = null;
        try {
            gen = pt.nextPolynomialList();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Ideal agen = new Ideal(pfac, gen);
        if (agen.isONE()) {
            throw new IllegalArgumentException("ideal is 1: " + expr);
        }
        if (agen.isZERO()) {
            QuotientRing qfac;
            QuotientRing base = qfac = new QuotientRing(pfac);
            return new ExtensionFieldBuilder(base);
        }
        ResidueRing base = afac = new ResidueRing(agen);
        return new ExtensionFieldBuilder(base);
    }

    public ExtensionFieldBuilder realAlgebraicExtension(String var, String expr, String root) {
        RealAlgebraicRing rfac;
        String[] variables = new String[]{var};
        RingElem one = (RingElem)this.factory.getONE();
        if (!(one instanceof Rational)) {
            throw new IllegalArgumentException("base field not instance of Rational");
        }
        TermOrder to = new TermOrder(2);
        GenPolynomialRing pfac = new GenPolynomialRing(this.factory, to, variables);
        Element gen = pfac.parse(expr);
        RingFactory cf = pfac.coFac;
        Interval iv = RootUtil.parseInterval(cf, root);
        RealAlgebraicRing base = rfac = new RealAlgebraicRing(gen, iv);
        return new ExtensionFieldBuilder(base);
    }

    public ExtensionFieldBuilder complexAlgebraicExtension(String var, String expr, String root) {
        ComplexAlgebraicRing rfac;
        String[] variables = new String[]{var};
        RingElem one = (RingElem)this.factory.getONE();
        if (!(one instanceof Complex)) {
            throw new IllegalArgumentException("base field not instance of Complex");
        }
        GenPolynomialRing pfac = new GenPolynomialRing(this.factory, variables);
        Element gen = pfac.parse(expr);
        RingFactory cf = pfac.coFac;
        Rectangle rt = RootUtil.parseRectangle(cf, root);
        ComplexAlgebraicRing base = rfac = new ComplexAlgebraicRing(gen, rt);
        return new ExtensionFieldBuilder(base);
    }

    public String toString() {
        StringBuffer s = new StringBuffer(" ");
        s.append(this.factory.toString());
        s.append(" ");
        return s.toString();
    }

    public String toScript() {
        StringBuffer s = new StringBuffer(" ");
        s.append(this.factory.toScript());
        s.append(" ");
        return s.toString();
    }
}

